
//
// To jest przykadowy kod z podrozdziau 19.2.4 Funkcja push_back ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

//------------------------------------------------------------------------------

class vector {
    int sz;       // liczba elementw
    double* elem; // adres pierwszego elementu
    int space;    // liczba elementw plus wolna przestrze
                  // dla nowych elementw (biecy rozmiar alokacji)
public:
    vector();
    void reserve(int newalloc);
    int  capacity() const;
    void resize(int newsize);
    void push_back(double d);
    // ...
};

//------------------------------------------------------------------------------

vector::vector() :sz(0), elem(0), space(0) {}

//------------------------------------------------------------------------------

void vector::reserve(int newalloc)
{
    if (newalloc<=space) return;             // Nigdy nie zmniejszaj obszaru alokacji.
    double* p = new double[newalloc];        // Alokuje now przestrze.
    for (int i=0; i<sz; ++i) p[i] = elem[i]; // Kopiuje stare elementy.
    delete[ ] elem;                          // Dealokuje star przestrze.
    elem = p;
    space = newalloc;        
}

//------------------------------------------------------------------------------

int vector::capacity() const { return space; }

//------------------------------------------------------------------------------

void vector::resize(int newsize)
// Zmienia rozmiar wektora na newsize.
// Kady nowy element inicjuje domyln wartoci 0.0.
{
    reserve(newsize);
    for (int i=sz; i<newsize; ++i) elem[i] = 0;    // Inicjuje nowe elementy.
    sz = newsize;    
}

//------------------------------------------------------------------------------

void vector::push_back(double d)
 // Zwiksza rozmiar wektora o jeden i inicjuje nowy element wartoci d.
{
    // Rezerwuje wicej przestrzeni.
    if (space==0)
        reserve(8);
    else 
    if (space==sz)
        reserve(2*space);

    elem[sz] = d;    // Dodaje d na kocu.
    ++sz;            // Zwiksza rozmiar (sz okrela liczb elementw).
}

//------------------------------------------------------------------------------

int main()
{
    vector v;
    v.reserve(10);
    v.resize(4);
    v.push_back(7);
    return v.capacity();
}

//------------------------------------------------------------------------------
