
//
// To jest przykadowy kod z podrozdziau 14.3.3 Przesanianie ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include <iostream>

using namespace std;

//------------------------------------------------------------------------------

struct B {
    virtual void f() const { cout << "B::f  "; }
    void g() const { cout << "B::g  "; }  // niewirtualna
};

//------------------------------------------------------------------------------

struct D : B {
    void f() const { cout << "D::f  "; }  // Przesania B::f.
    void g() { cout << "D::g  "; }
};

//------------------------------------------------------------------------------

struct DD : D {
    void f() { cout << "DD::f  "; }       // Nie przesania D::f (nie const).
    void g() const { cout << "DD::g  "; }
};

//------------------------------------------------------------------------------

void call(const B& b)
    // D jest rodzajem B, a wic funkcja call() moe przyjmowa argumenty typu D.
    // DD jest rodzajem D, za D jest rodzajem B, a wic funkcja call() moe przyjmowa argumenty typu DD.
{
    b.f();
    b.g();
}

//------------------------------------------------------------------------------

int main()
try
{
    B b;
    D d;
    DD dd;

    call(b);
    call(d);
    call(dd);

    b.f();
    b.g();

    d.f();
    d.g();

    dd.f();
    dd.g();
}
catch(exception& e) {
    // Raport o bdzie.
    return 1;
}
catch(...) {
    // Raport o bdzie.
    return 2;
}

//------------------------------------------------------------------------------
