
//
// To jest przykadowy kod z podrozdziau 10.7.1 Rozoenie problemu na mniejsze czci ksiki 
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include "std_lib_facilities.h"

//------------------------------------------------------------------------------

void skip_to_int()
{
    if (cin.fail()) {          // Znaleziono co, co nie jest liczb cakowit.
        cin.clear();           // Chcemy przyjrze si znakom.
        char ch;
        while (cin>>ch){       // Odrzuca niecyfry.
            if (isdigit(ch)) {
                cin.unget();   // Oddaje cyfr z powrotem, dziki czemu mona odczyta liczb.
                               
                return;
            }
        }
    }
    error("Brak danych.");         // Stan eof lub bad  poddajemy si.
}

//------------------------------------------------------------------------------

int main()
try
{
    cout << "Podaj liczb cakowit z zakresu od 1 do 10 (wcznie):\n";
    int n = 0;
    while (true) {
        if (cin>>n) {          // Mamy liczb cakowit; sprawdzamy j.
            if (1<=n && n<=10) break;
            cout << "Niestety " << n
                << " nie naley do zakresu <1,10>. Sprbuj jeszcze raz.\n";
        }
        else {
            cout << "Niestety, to nie bya liczba. Sprbuj jeszcze raz.\n";
            skip_to_int();
        }
    }
    // Jeli dotrzemy do tego miejsca, oznacza to, e n naley do zakresu <1,10>.
    return n;
}
catch (exception& e) {
    cerr << "Bd: " << e.what() << '\n'; 
    return 1;
}
catch (...) {
    cerr << "Nieznany wyjtek!\n"; 
    return 2;
}

//------------------------------------------------------------------------------
