
//
// To jest przykadowy kod z podrozdziau 10.6 Obsuga bdw wejcia i wyjcia ksiki 
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include "std_lib_facilities.h"

//------------------------------------------------------------------------------

void fill_vector(istream& ist, vector<int>& v, char terminator)
// Wczytuje liczby cakowite ze strumienia ist do wektora v do chwili napotkania eof() lub znaku oznaczajcego koniec danych.
{
    int i = 0;
    while (ist >> i) v.push_back(i);
    if (ist.eof()) return;    // Dobrze: znaleziono koniec pliku.

    // Nie good(), nie bad() i nie eof(), a wic ist musi by w stanie fail().
    ist.clear();              // Czyci stan strumienia.
    char c;
    ist>>c;                   // Wczytanie znaku z nadziej, e to znak koczcy.

    if (c != terminator) {    // Nie znak koczcy, bdzie niepowodzenie.
        ist.unget();          // Moe wywoujcy bdzie wiedzia, co zrobi z tym znakiem.
        ist.clear(ios_base::failbit); // Ustawia stan na fail().
    }
}

//------------------------------------------------------------------------------

int main()
try
{
    cin.exceptions(cin.exceptions()|ios_base::badbit);

    vector<int> v;
    fill_vector(cin, v, '*');
}
catch (exception& e) {
    cerr << "Bd: " << e.what() << '\n'; 
    return 1;
}
catch (...) {
    cerr << "Nieznany wyjtek!\n"; 
    return 2;
}

//------------------------------------------------------------------------------
