
//
// To jest przykadowy kod z podrozdziau 20.8 Dostosowanie wektora do biblioteki STL ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

//------------------------------------------------------------------------------

template<class T> class allocator {
public:
    // ...
    T* allocate(int n);            // Alokacja przestrzeni dla n obiektw typu T.
    void deallocate(T* p, int n);  // Dealokacja n obiektw typu T, zaczynajc od p.

    void construct(T* p, const T& v); // Tworzy obiekt typu T z wartoci v w p.
    void destroy(T* p);            // Usuwa ten obiekt T z p.
};

//------------------------------------------------------------------------------

template<class T, class A = allocator<T> > class vector {
    int sz;     // rozmiar
    T*  elem;   // wskanik na elementy
    int space;  // liczba elementw plus liczba wolnych miejsc w pamici
    A   alloc;  // obsuga pamici dla elementw za pomoc alloc
public:
    typedef unsigned long size_type;
    typedef T             value_type;
    typedef T*            iterator;    // Elem* jest najprostszym moliwym iteratorem.
    typedef const T*      const_iterator;

    iterator       begin();
    const_iterator begin() const;
    iterator       end();
    const_iterator end() const;

    size_type size();
    int capacity() const { return space; }

    // ... caa reszta z rozdziau 19 i podrozdziau 20.5 ...

    T&       back();
    iterator insert(iterator p, const T& val);
    iterator erase(iterator p);    
};

//------------------------------------------------------------------------------

template<class T, class A> 
typename vector<T,A>::iterator vector<T,A>::erase(iterator p)
{
    if (p==end()) return p;
    for (iterator pos = p+1; pos!=end(); ++pos)
        *(pos-1) = *pos; // Kopiuje element o jedn pozycj w lewo.
    alloc.destroy(&*p);  // Usuwa nadmiarow kopi ostatniego elementu.
    --sz;
    return p;
}

//------------------------------------------------------------------------------

template<class T, class A>
typename vector<T,A>::iterator vector<T,A>::insert(iterator p, const T& val)
{
    int index = p-begin();
    if (size()==capacity()) reserve(2*size());    // Zapewniamy miejsce.

    // Skopiowanie najpierw elementu w niezainicjowan przestrze:
    alloc.construct(elem+sz,*back());
    ++sz;
    iterator pp = begin()+index; // Miejsce, w ktrym zostanie wstawiona warto val.
    for (iterator pos = end()-1; pos!=pp; --pos)
        *pos = *(pos-1);         // Kopiuje elementy o jedno miejsce w prawo.
    *(begin()+index) = val;      // wstawia val
    return pp;
}

//------------------------------------------------------------------------------
