
//
// To jest przykadowy kod z podrozdziau 19.4.2 Sprawdzanie zakresu i wyjtki ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include <iostream>
#include <stdexcept>

using std::cin;
using std::cout;
using std::cerr;

//------------------------------------------------------------------------------

template<class T> class allocator {
public:
    // ...
    T* allocate(int n);            // Alokuje przestrze dla n obiektw typu T.
    void deallocate(T* p, int n);  // Dealokuje n obiektw typu T, zaczynajc od p.

    void construct(T* p, const T& v); // Konstruuje T z wartoci v w p.
    void destroy(T* p);            // Usuwa T z p.
};

//------------------------------------------------------------------------------

struct out_of_range { /* ... */ }; // Klasa do raportowania o bdach zakresu.

template<class T, class A = allocator<T> > class vector {
    A alloc;                       // Alokuje przestrze dla elementw.
    int sz;                        // rozmiar
    T* elem;                       // wskanik na elementy
    int space;                     // size+free_space
public:
    vector() : sz(0), elem(0), space(0) { }    
    vector(int s);

    vector(const vector&);            // konstruktor kopiujcy
    vector& operator=(const vector&); // przypisanie kopiujce

    ~vector() { delete[ ] elem; }     // destruktor

    T& at(int n);                     // Dostp kontrolowany    
    const T& at(int n) const;         // Dostp kontrolowany

    T& operator[ ](int n);            // Dostp niekontrolowany
    const T& operator[ ](int n) const;// Dostp niekontrolowany

    int size() const { return sz; }   // aktualny rozmiar
    int capacity() const { return space; }
};

//------------------------------------------------------------------------------

template<class T, class A >  T& vector<T,A>::at(int n)
{
    if (n<0 || sz<=n) throw out_of_range();
    return elem[n];
}

//------------------------------------------------------------------------------

template<class T, class A >  T& vector<T,A>::operator[ ](int n) // jak poprzednio
{
    return elem[n];
}

//------------------------------------------------------------------------------

void print_some(vector<int>& v)
{
    int i = -1;
    cin >> i;
    while(i!= -1) try {
        cout << "v[" << i << "]==" << v.at(i) << "\n";
    }
    catch(out_of_range) {
        cout << "Nieprawidowy indeks: " << i << "\n";
    }
}

//------------------------------------------------------------------------------

int main()
try
{
    vector<int> v(10);
    print_some(v);
}
catch (std::exception& e) {
    cerr << "Bd: " << e.what() << '\n'; 
    return 1;
}
catch (...) {
    cerr << "Ojej: nieznany wyjtek!\n"; 
    return 2;
}

//------------------------------------------------------------------------------
