
//
// Przykadowy kod z rozdziau 5.5.3 "Raportowanie bdw" ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include "std_lib_facilities.h"

//------------------------------------------------------------------------------

// Prosi uytkownika o podanie odpowiedzi tak lub nie.
// Zwraca warto 'z' oznaczajc z odpowied (tzn. inn ni tak lub nie).

char ask_user(string question)
{
    cout << question << "? (tak lub nie)\n";
    string answer = " ";
    cin >> answer;
    if (answer =="t" || answer=="tak") return 't'; 
    if (answer =="n" || answer=="nie") return 'n';
    return 'z';    // 'z' oznacza za odpowied.
}

//------------------------------------------------------------------------------


int area(int length, int width);    // Oblicza pole powierzchni prostokta.

int framed_area(int x, int y)       // Oblicza pole powierzchni w ramce.
{ 
    const int frame_width = 2;
    if (x-frame_width<=0 || y-frame_width<=0)
        error("Argument funkcji area() wywoanej przez framed_area() nie jest dodatni.");
    return area(x-frame_width,y-frame_width);
}

//------------------------------------------------------------------------------

// Oblicza pole powierzchni prostokta.
// Warto zwrotna 1 oznacza zy argument.
int area(int length, int width)
{
    if (length<=0 || width <=0) return -1;
    return length*width;
}

//------------------------------------------------------------------------------

int f(int x, int y, int z)
{
    cout << "x=" << x << "; y=" << y << "; z=" << z << endl;

    int area1 = area(x,y);
    if (area1<=0) error("Pole powierzchni nie jest dodatnie.");
    int area2 = framed_area(1,z);
    int area3 = framed_area(y,z);
    double ratio = double(area1)/area3;
    // ...

    cout << "area1=" << area1 << endl
         << "area2=" << area2 << endl
         << "area3=" << area3 << endl;
}

//------------------------------------------------------------------------------

int main()
try
{
    f( 1, 2, 3);
    f(-1, 2, 3);
    f( 1,-2, 3);
    f(-1,-2, 3);
    f( 1, 2,-3);
    f(-1, 2,-3);
    f( 1,-2,-3);
    f(-1,-2,-3);
    char answer = ask_user("Przeczytae wyniki?");
}
catch (exception& e) {
    cerr << "Bd: " << e.what() << '\n'; 
    return 1;
}
catch (...) {
    cerr << "Nieznany wyjtek!\n"; 
    return 2;
}

//------------------------------------------------------------------------------
