
//
// To jest przykadowy kod z podrozdziau 21.7.2 Iteratory strumieni ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include <algorithm>
#include <fstream>
#include <iostream>
#include <iterator>
#include <string>
#include <vector>

using namespace std;

//------------------------------------------------------------------------------

void foo()
{
    ostream_iterator<string> oo(cout);        // Przypisanie do *oo jest rwnowane z zapisem w cout.

    *oo = "Witaj, ";    // Oznacza cout << "Witaj, "
    ++oo;               // Przygotowanie do nastpnej operacji wyjciowej.
    *oo = "wiecie!\n";   // Oznacza cout << "wiecie!\n".

    istream_iterator<string> ii(cin); // reading *ii is to read a string from cin

    string s1 = *ii;    // Oznacza cin>>s1.
    ++ii;               // Przygotowanie na nastpn operacj wejciow.
    string s2 = *ii;    // Oznacza cin>>s2.
}

//------------------------------------------------------------------------------

int main()
{
    string from, to;
    cin >> from >> to;  // Pobiera nazwy plikw rdowego i docelowego.

    ifstream is(from.c_str());            // Otwiera strumie wejciowy.
    ofstream os(to.c_str());              // Otwiera strumie wyjciowy.

    istream_iterator<string> ii(is);      // Tworzy iterator wejciowy dla strumienia.
    istream_iterator<string> eos;         // wartownik wejcia
    ostream_iterator<string> oo(os,"\n"); // Tworzy iterator wyjciowy dla strumienia.

    vector<string> b(ii,eos);             // b jest wektorem inicjowanym danymi wejciowymi.
    sort(b.begin() ,b.end());             // sortuje bufor
    copy(b.begin() ,b.end() ,oo);         // Kopiuje zawarto bufora na wyjcie.

}

//------------------------------------------------------------------------------
