
//
// To jest przykadowy kod z podrozdziau 19.3.4 Liczby cakowite jako parametry szablonw ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include <iostream>
#include <vector>

using std::cout;
using std::vector;

//------------------------------------------------------------------------------

template<class T, int N> struct array {
    T elem[N];                  // Przechowuje elementy w tablicy skadowej.

    // Polega na domylnych konstruktorach, destruktorze i przypisaniu.

    T& operator[ ] (int n) { return elem[n]; } // dostp: zwraca referencj
    const T& operator[ ] (int n) const { return elem[n]; }

    T* data() { return elem; }  // konwersja na T*
    const T* data() const { return elem; }

    int size() const  { return N; }    
};

//------------------------------------------------------------------------------

array<int,256> gb;          // 256 liczb cakowitych
array<double,6> ad = { 0.0, 1.1, 2.2, 3.3, 4.4, 5.5 };    // Zwr uwag na inicjator!
const int max = 1024;

void some_fct(int n)
{
    array<char,max> loc;
    //array<char,n> oops;         // Bd: warto n nie jest znana kompilatorowi.
    // ...
    array<char,max> loc2 = loc; // Tworzy kopi zapasow.
    // ...
    loc = loc2;                 // przywrcenie
    // ...
}

//------------------------------------------------------------------------------

template<class C> void printout(const C& c)
{
    for(int i = 0; i<c.size(); ++i) cout << c[i] <<'\n';
}

//------------------------------------------------------------------------------

int main(int argc, char* argv[])
{
    //double* p = ad;             // Bd: nie mona stosowa niejawnej konwersji na wskanik.
    double* q = ad.data();      // Dobrze: jawna konwersja.

    printout(ad);               // wywoanie przez tablic
    vector<int> vi;
    // ...
    printout(vi);               // wywoanie przez wektor
}

//------------------------------------------------------------------------------
