
//
// To jest przykadowy kod z podrozdziau 6.9 "Strktura programu" ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include "std_lib_facilities.h"

//------------------------------------------------------------------------------

class Token {
public:
    char kind;        // Rodzaj tokenu.
    double value;     // Dla liczb: warto.
    Token(char ch)    // Tworzy token ze znaku.
        :kind(ch), value(0) { }    
    Token(char ch, double val)     // Tworzy token ze znaku i liczby typu double.
        :kind(ch), value(val) { }
};

//------------------------------------------------------------------------------

class Token_stream {
public: 
    Token_stream();   // Tworzy Token_stream wczytujcy ze strumienia cin.
    Token get();      // Pobiera token (funkcja get() jest zdefiniowana w innym miejscu).
    void putback(Token t);    // Wstawia token z powrotem.
private:
    bool full;        // Sprawdza czy w buforze jest token.
    Token buffer;     // Przechowuje token wstawiony z powrotem za pomoc funkcji putback().
};

//------------------------------------------------------------------------------

// Konstruktor ustawia tylko warto full w taki sposb, aby wskazywaa, e bufor jest pusty:
Token_stream::Token_stream()
:full(false), buffer(0)    // Bufor jest pusty
{
}

//------------------------------------------------------------------------------

// Funkcja skadowa putback() wstawia swj argument z powrotem do bufora strumienia Token_stream:
void Token_stream::putback(Token t)
{
    if (full) error("Funkcja putback() prbuje wstawi token do penego bufora.");
    buffer = t;       // Kopiuje t do bufora.
    full = true;      // Bufor jest peny.
}

//------------------------------------------------------------------------------

Token Token_stream::get()
{
    if (full) {       // Sprawdza czy jest ju gotowy token.
        // Usuwa token z bufora.
        full=false;
        return buffer;
    } 

    char ch;
    cin >> ch;    // Operator >> pomija biae znaki (spacje, znaki nowego wiersza, tabulatory itp.).

    switch (ch) {
    case ';':    // Oznacza drukowanie
    case 'q':    // Oznacza koniec
    case '(': case ')': case '+': case '-': case '*': case '/': 
        return Token(ch);        // Kady znak reprezentuje samego siebie.
    case '.':
    case '0': case '1': case '2': case '3': case '4':
    case '5': case '6': case '7': case '8': case '9':
        {    
            cin.putback(ch);         // Wstawia cyfr z powrotem do strumienia wejciowego.
            double val;
            cin >> val;              // Odczytuje liczb zmiennoprzecinkow.
            return Token('8',val);   // Znak 8 reprezentuje liczb.
        }
    default:
        error("Nieprawidowy token");
    }
}

//------------------------------------------------------------------------------

Token_stream ts;        /// Dostarcza funkcji get() i putback().

//------------------------------------------------------------------------------

double expression();    // Deklaracja, dziki ktrej funkcja primary() moe wywoa funkcj expression().

//------------------------------------------------------------------------------

// Obsuga liczb i nawiasw.
double primary()
{
    Token t = ts.get();
    switch (t.kind) {
    case '(':    // Obsuga '(' wyraenie ')'
        {    
            double d = expression();
            t = ts.get();
            if (t.kind != ')') error("')' by oczekiwany.");
            return d;
        }
    case '8':            // Do reprezentowania liczb suy znak 8.
        return t.value;  // Zwraca warto liczby.
    default:
        error("Oczekiwano czynnika.");
    }
}

//------------------------------------------------------------------------------

// Obsuga *, / i %.
double term()
{
    double left = primary();
    Token t = ts.get();        // Pobiera nastpny token ze strumienia wejciowego.

    while(true) {
        switch (t.kind) {
        case '*':
            left *= primary();
            t = ts.get();
            break;
        case '/':
            {    
                double d = primary();
                if (d == 0) error("Dzielenie przez zero.");
                left /= d; 
                t = ts.get();
                break;
            }
        default: 
            ts.putback(t);     // Wstawia t z powrotem do strumienia tokenw.
            return left;
        }
    }
}

//------------------------------------------------------------------------------

// Obsuga + i -.
double expression()
{
    double left = term();      // Wczytuje i oblicza warto skadnika.
    Token t = ts.get();        // Pobiera nastpny token ze strumienia wejciowego.

    while(true) {    
        switch(t.kind) {
        case '+':
            left += term();    // Oblicza warto skadnika i dodaje.
            t = ts.get();
            break;
        case '-':
            left -= term();    // Oblicza warto skadnika i odejmuje.
            t = ts.get();
            break;
        default: 
            ts.putback(t);     // Wstawia t z powrotem do strumienia tokenw.
            return left;       // Nie ma wicej znakw = i -. Zwraca wynik.
        }
    }
}

//------------------------------------------------------------------------------

int main()
try
{
    double val = 0;
    while (cin) {
        Token t = ts.get();

        if (t.kind == 'q') break; // Oznacza koniec.
        if (t.kind == ';')        // Oznacza drukowanie.
            cout << "=" << val << '\n';
        else
            ts.putback(t);
        val = expression();
    }
}
catch (exception& e) {
    cerr << "Bd: " << e.what() << '\n'; 
    return 1;
}
catch (...) {
    cerr << "Nieznany wyjtek!\n"; 
    return 2;
}

//------------------------------------------------------------------------------
