---------------------------------------------------
-- Sams Teach Yourself Oracle PL/SQL in Ten Minutes
-- http://forta.com/books/0672328666
-- Example table population scripts
---------------------------------------------------


---------------------------------------------
-- Wypełnij tabelę klienci 
---------------------------------------------
INSERT INTO klienci(kl_id, nazwa_kl, adres_kl, miasto_kl, woj_kl, kod_kl, kraj_kl, kontakt_kl, email_kl)
VALUES(10001, 'Coyote Inc.', 'ul. Helska 2', 'Sopot', 'POM', '81-718', 'POL', 'Y Lee', 'ylee@coyote.com');
INSERT INTO klienci(kl_id, nazwa_kl, adres_kl, miasto_kl, woj_kl, kod_kl, kraj_kl, kontakt_kl)
VALUES(10002, 'Mouse House', 'ul. 1 Maja 3', 'Katowice', 'SLK', '40-224', 'POL', 'Jerry Mouse');
INSERT INTO klienci(kl_id, nazwa_kl, adres_kl, miasto_kl, woj_kl, kod_kl, kraj_kl, kontakt_kl, email_kl)
VALUES(10003, 'Wascals', 'ul. Dąbrowskiego 1', 'Poznań', 'WKP', '61-332', 'POL', 'Jim Jones', 'rabbit@wascally.com');
INSERT INTO klienci(kl_id, nazwa_kl, adres_kl, miasto_kl, woj_kl, kod_kl, kraj_kl, kontakt_kl, email_kl)
VALUES(10004, 'Yosemite Place', 'Aleje Jerozolimskie 365', 'Warszawa', 'MAZ', '00-900', 'POL', 'Y Sam', 'sam@yosemite.com');
INSERT INTO klienci(kl_id, nazwa_kl, adres_kl, miasto_kl, woj_kl, kod_kl, kraj_kl, kontakt_kl)
VALUES(10005, 'E Fudd', 'ul. Agawy 30', 'Kraków', 'MAL', '30-737', 'POL', 'E Fudd');


---------------------------------------------
-- Wypełnij tabelę dostawcy
---------------------------------------------
INSERT INTO dostawcy(id_dost, nazwa_dost, adres_dost, miasto_dost, woj_dost, kod_dost, kraj_dost)
VALUES(1001,'Anvils R Us','123 Main Street','Southfield','MI','48075', 'USA');
INSERT INTO dostawcy(id_dost, nazwa_dost, adres_dost, miasto_dost, woj_dost, kod_dost, kraj_dost)
VALUES(1002,'LT Supplies','500 Park Street','Anytown','OH','44333', 'USA');
INSERT INTO dostawcy(id_dost, nazwa_dost, adres_dost, miasto_dost, woj_dost, kod_dost, kraj_dost)
VALUES(1003,'ACME','555 High Street','Los Angeles','CA','90046', 'USA');
INSERT INTO dostawcy(id_dost, nazwa_dost, adres_dost, miasto_dost, woj_dost, kod_dost, kraj_dost)
VALUES(1004,'Furball Inc.','1000 5th Avenue','New York','NY','11111', 'USA');
INSERT INTO dostawcy(id_dost, nazwa_dost, adres_dost, miasto_dost, woj_dost, kod_dost, kraj_dost)
VALUES(1005,'Jet Set','42 Galaxy Road','Londyn', NULL,'N16 6PS', 'Anglia');
INSERT INTO dostawcy(id_dost, nazwa_dost, adres_dost, miasto_dost, woj_dost, kod_dost, kraj_dost)
VALUES(1006,'Jouets Et Ours','1 Rue Amusement','Paryż', NULL,'45678', 'Francja');


---------------------------------------------
-- Wypełnij tabelę produkty
---------------------------------------------
INSERT INTO produkty(id_prod, id_dost, nazwa_prod, cena_prod, opis_prod)
VALUES('ANV01', 1001, 'Kowadło .5 t', 5.99, 'Kowadło .5 t, czarne, w komplecie z uchwytem');
INSERT INTO produkty(id_prod, id_dost, nazwa_prod, cena_prod, opis_prod)
VALUES('ANV02', 1001, 'Kowadło 1 t', 9.99, 'Kowadło 1 t, czarne, w komplecie z uchwytem i futerałem');
INSERT INTO produkty(id_prod, id_dost, nazwa_prod, cena_prod, opis_prod)
VALUES('ANV03', 1001, 'Kowadło 2 t', 14.99, 'Kowadło 2 t, czarne, w komplecie z uchwytem i futerałem');
INSERT INTO produkty(id_prod, id_dost, nazwa_prod, cena_prod, opis_prod)
VALUES('OL1', 1002, 'Puszka oleju', 8.99, 'Puszka oleju, czerwona');
INSERT INTO produkty(id_prod, id_dost, nazwa_prod, cena_prod, opis_prod)
VALUES('FU1', 1002, 'Lonty', 3.42, 'tuzin, bardzo długie');
INSERT INTO produkty(id_prod, id_dost, nazwa_prod, cena_prod, opis_prod)
VALUES('SLING', 1003, 'Proca', 4.49, 'Proca, rozmiar uniwersalny');
INSERT INTO produkty(id_prod, id_dost, nazwa_prod, cena_prod, opis_prod)
VALUES('TNT1', 1003, 'Dynamit (1 laska)', 2.50, 'Dynamit, czerowy, jedna laska');
INSERT INTO produkty(id_prod, id_dost, nazwa_prod, cena_prod, opis_prod)
VALUES('TNT2', 1003, 'Dynamit (5 lasek)', 10, 'Dynamit, czerwony, komplet 10 lasek');
INSERT INTO produkty(id_prod, id_dost, nazwa_prod, cena_prod, opis_prod)
VALUES('FB', 1003, 'Karma dla ptaków', 10, 'Duża torba (odpowiednia dla strusi)');
INSERT INTO produkty(id_prod, id_dost, nazwa_prod, cena_prod, opis_prod)
VALUES('FC', 1003, 'Marchewki', 2.50, 'Marchewki (tylko w sezonie polowań na króliki)');
INSERT INTO produkty(id_prod, id_dost, nazwa_prod, cena_prod, opis_prod)
VALUES('SAFE', 1003, 'Sejf', 50, 'Sejf z zamkiem szyfrowym');
INSERT INTO produkty(id_prod, id_dost, nazwa_prod, cena_prod, opis_prod)
VALUES('DTNTR', 1003, 'Detonator', 13, 'Detonator (zasilany tłokiem), Lonty nie są dołączone');
INSERT INTO produkty(id_prod, id_dost, nazwa_prod, cena_prod, opis_prod)
VALUES('JP1000', 1005, 'JetPack 1000', 35, 'JetPack 1000, przeznaczony do jednorazowego użytku');
INSERT INTO produkty(id_prod, id_dost, nazwa_prod, cena_prod, opis_prod)
VALUES('JP2000', 1005, 'JetPack 2000', 55, 'JetPack 2000, do wielokrotnego użytku');



---------------------------------------------
-- Wypełnij tabelę zamowienia
---------------------------------------------
INSERT INTO zamowienia(numer_zam, data_zam, kl_id)
VALUES(20005, TO_DATE('2015-02-01', 'yyyy-mm-dd'), 10001);
INSERT INTO zamowienia(numer_zam, data_zam, kl_id)
VALUES(20006, TO_DATE('2015-02-12', 'yyyy-mm-dd'), 10003);
INSERT INTO zamowienia(numer_zam, data_zam, kl_id)
VALUES(20007, TO_DATE('2015-02-28', 'yyyy-mm-dd'), 10004);
INSERT INTO zamowienia(numer_zam, data_zam, kl_id)
VALUES(20008, TO_DATE('2015-03-03', 'yyyy-mm-dd'), 10005);
INSERT INTO zamowienia(numer_zam, data_zam, kl_id)
VALUES(20009, TO_DATE('2015-03-08', 'yyyy-mm-dd'), 10001);


---------------------------------------------
-- Wypełnij tabelę pozycje
---------------------------------------------
INSERT INTO pozycje(numer_zam, pozycja_zam, id_prod, ilosc, cena_poz)
VALUES(20005, 1, 'ANV01', 10, 5.99);
INSERT INTO pozycje(numer_zam, pozycja_zam, id_prod, ilosc, cena_poz)
VALUES(20005, 2, 'ANV02', 3, 9.99);
INSERT INTO pozycje(numer_zam, pozycja_zam, id_prod, ilosc, cena_poz)
VALUES(20005, 3, 'TNT2', 5, 10);
INSERT INTO pozycje(numer_zam, pozycja_zam, id_prod, ilosc, cena_poz)
VALUES(20005, 4, 'FB', 1, 10);
INSERT INTO pozycje(numer_zam, pozycja_zam, id_prod, ilosc, cena_poz)
VALUES(20006, 1, 'JP2000', 1, 55);
INSERT INTO pozycje(numer_zam, pozycja_zam, id_prod, ilosc, cena_poz)
VALUES(20007, 1, 'TNT2', 100, 10);
INSERT INTO pozycje(numer_zam, pozycja_zam, id_prod, ilosc, cena_poz)
VALUES(20008, 1, 'FC', 50, 2.50);
INSERT INTO pozycje(numer_zam, pozycja_zam, id_prod, ilosc, cena_poz)
VALUES(20009, 1, 'FB', 1, 10);
INSERT INTO pozycje(numer_zam, pozycja_zam, id_prod, ilosc, cena_poz)
VALUES(20009, 2, 'OL1', 1, 8.99);
INSERT INTO pozycje(numer_zam, pozycja_zam, id_prod, ilosc, cena_poz)
VALUES(20009, 3, 'SLING', 1, 4.49);
INSERT INTO pozycje(numer_zam, pozycja_zam, id_prod, ilosc, cena_poz)
VALUES(20009, 4, 'ANV03', 1, 14.99);


---------------------------------------------
-- Wypełnij tabelę prod_uwagi
---------------------------------------------
INSERT INTO prod_uwagi(id_uw, id_prod, data_uw, tekst_uw)
VALUES(101, 'TNT2', TO_DATE('2015-02-17', 'yyyy-mm-dd'),
'Skarga klienta:
Laski nie są zapakowane pojedynczo, bardzo łatwo można zdetonować je wszystkie przez pomyłkę.
Zaleca się pakowanie osobno.'
);
INSERT INTO prod_uwagi(id_uw, id_prod, data_uw, tekst_uw)
VALUES(102, 'OL1', TO_DATE('2015-02-18', 'yyyy-mm-dd'),
'Wysła się pełne puszki, nie można ich napełniać ponownie.
Należy zamówić nową puszkę, jeżeli chce się napełnić ponownie.'
);
INSERT INTO prod_uwagi(id_uw, id_prod, data_uw, tekst_uw)
VALUES(103, 'SAFE', TO_DATE('2015-02-18', 'yyyy-mm-dd'),
'Sejf jest zabezpieczony szyfrem, który nie jest dołączony do niego.
Nie jest to duży problem, ponieważ klienci otwierają sejfy wysadzając je w powietrze lub zrzucając.'
);
INSERT INTO prod_uwagi(id_uw, id_prod, data_uw, tekst_uw)
VALUES(104, 'FC', TO_DATE('2015-02-19', 'yyyy-mm-dd'),
'Różna ilość, sprzedawane na worki.
Gwarancja jasnego, pomarańczowego koloru, odpowiednie jako przynęta na królika.'
);
INSERT INTO prod_uwagi(id_uw, id_prod, data_uw, tekst_uw)
VALUES(105, 'TNT2', TO_DATE('2015-02-20', 'yyyy-mm-dd'),
'Lonty są krótkie i klienci skarżą się, że detonują zbyt szybko.
Dostępne są dłuższe lonty (produkt FU1), które powinny być zalecane.'
);
INSERT INTO prod_uwagi(id_uw, id_prod, data_uw, tekst_uw)
VALUES(106, 'TNT2', TO_DATE('2015-02-22', 'yyyy-mm-dd'),
'Brak zapałek w zestawie, zaleca się dokupić zapałki lub detonator (pozycja DTNTR).'
);
INSERT INTO prod_uwagi(id_uw, id_prod, data_uw, tekst_uw)
VALUES(107, 'SAFE', TO_DATE('2015-02-23', 'yyyy-mm-dd'),
'Zwroty nie będą przyjmowane, jeżeli sejf zostanie otwarty przy pomocy materiałów wybuchowych.'
);
INSERT INTO prod_uwagi(id_uw, id_prod, data_uw, tekst_uw)
VALUES(108, 'ANV01', TO_DATE('2015-02-25', 'yyyy-mm-dd'),
'Wielokrotne zwroty, kowadła nie spadają dostatecznie szybko, lub spadają na kupującego. Zalecamy klientowi wzięcie pod uwagę cięższych kowadeł.'
);
INSERT INTO prod_uwagi(id_uw, id_prod, data_uw, tekst_uw)
VALUES(109, 'ANV03', TO_DATE('2015-03-01', 'yyyy-mm-dd'),
'Produkt jest niesamowicie ciężki. Zaprojektowany do zrzucania, nie zaleca się używania z procami, wielokrążkami lub linami.'
);
INSERT INTO prod_uwagi(id_uw, id_prod, data_uw, tekst_uw)
VALUES(110, 'FC', TO_DATE('2015-03-01', 'yyyy-mm-dd'),
'Reklamacja klienta: królik zdołał wykryć pułapkę, jedzenie jest teraz mniej skuteczne.'
);
INSERT INTO prod_uwagi(id_uw, id_prod, data_uw, tekst_uw)
VALUES(111, 'SLING', TO_DATE('2015-03-02', 'yyyy-mm-dd'),
'Wysyłane w częściach, wymaga podstawowych narzędzi (w tym przerośniętego młota).'
);
INSERT INTO prod_uwagi(id_uw, id_prod, data_uw, tekst_uw)
VALUES(112, 'SAFE', TO_DATE('2015-03-02', 'yyyy-mm-dd'),
'Reklamacja klienta:
Można łatwo wyciąć otwór w podłodze przy pomocy piły ręcznej.'
);
INSERT INTO prod_uwagi(id_uw, id_prod, data_uw, tekst_uw)
VALUES(113, 'ANV01', TO_DATE('2015-03-05', 'yyyy-mm-dd'),
'Reklamacja klienta:
Niedość ciężkie, aby wytworzyć gwiazdku krążące nad głową ofiary. Do zrzucania zalecić ANV02 lub ANV03.'
);
INSERT INTO prod_uwagi(id_uw, id_prod, data_uw, tekst_uw)
VALUES(114, 'SAFE', TO_DATE('2015-03-07', 'yyyy-mm-dd'),
'Telefon od osoby uwięzionej w sejfie, który spadł na ziemię, sugeruje dorobienie wyjścia awaryjego.
Uwaga przekazana producentowi.'
);
