REM $Id$
REM Z "Nauka Oracle PL/SQL" strona 291

REM Ciao pakietu, ktry pobiera dane z Biblioteki Kngresu

REM Prawdopodobnie SET SCAN OFF jest nieobsugiwane, uywamy wic SET DEFINE OFF

SET DEFINE OFF

CREATE OR REPLACE PACKAGE BODY webkatman
AS
   id_sesji_l VARCHAR2(64);
   niedostepny_id_sesji EXCEPTION;

   FUNCTION id_sesji
   RETURN VARCHAR2
   IS
      czesci_strony UTL_HTTP.HTML_PIECES;
      komponenty OWA_TEXT.VC_ARR;
      duza_strona VARCHAR2(32767);
   BEGIN
      IF id_sesji_l IS NULL
      THEN
         czesci_strony := UTL_HTTP.REQUEST_PIECES(webkatman.url_poc);

         FOR nr_czesci IN czesci_strony.FIRST..czesci_strony.LAST
         LOOP
            duza_strona := SUBSTR(duza_strona || czesci_strony(nr_czesci), 1, 32767);
         END LOOP;

         IF OWA_PATTERN.MATCH(duza_strona, 'NAME="SESSION_ID" VALUE="(\d*)"',
                              komponenty)
         THEN
            id_sesji_l := komponenty(1);
         ELSE
            RAISE niedostepny_id_sesji;
         END IF;
      END IF;

      RETURN id_sesji_l;
   END id_sesji;

   FUNCTION danekat (isbn IN VARCHAR2, ponowienia IN PLS_INTEGER)
   RETURN VARCHAR2
   IS
      buf VARCHAR2(2000);
      sesja_wygasla EXCEPTION;
   BEGIN
      buf := UTL_HTTP.REQUEST(url_frag_do_pobrania || '&TERM_1='
                || isbn || '&SESSION_ID=' || id_sesji());

      IF INSTR(buf, 'Twoja sesja wygasa') > 0
      THEN
         RAISE sesja_wygasla;
      END IF;

      RETURN buf;

   EXCEPTION
      WHEN niedostepny_id_sesji
           OR sesja_wygasla
      THEN
         IF ponowienia > 0
         THEN
            RETURN danekat(isbn, ponowienia - 1);
         ELSE
            exc.mojeraise(exc.nie_pobrano_odleglego_url_cd);
         END IF;
   END danekat;
END;
/

SHOW ERRORS

