REM $Id: ksiazkademozapytania.pro,v 1.1 2001/11/30 23:19:50 bill Exp $
REM Z "Nauka Oracle PL/SQL" strona 177

REM Demonstruje uycie procedury nopu.tworzwhere w celu utworzenia wyraenia
REM where dla instrukcji dynamicznego SQL

CREATE OR REPLACE PROCEDURE ksiazkademozapytania (isbn_in IN VARCHAR2,
   autor_in IN VARCHAR2, tytul_in IN VARCHAR2, data_in IN VARCHAR2)
AS
   TYPE kcur_t IS REF CURSOR;
   kcur kcur_t;
   krec ksiazki%ROWTYPE;
   wyrazenie_where VARCHAR2(2048);
BEGIN
   nopu.tworzwhere(wyrazenie_where, 'isbn', isbn_in);
   nopu.tworzwhere(wyrazenie_where, 'autor', autor_in);
   nopu.tworzwhere(wyrazenie_where, 'tytul', tytul_in);
   nopu.tworzwhere(wyrazenie_where, 'data_wydania', data_in,
      typ_danych => 'DATE', format_danych => 'DD-MON-YYYY');
   OPEN kcur FOR 'SELECT * FROM ksiazki ' || wyrazenie_where;
   LOOP
      FETCH kcur INTO krec;
      EXIT WHEN kcur%NOTFOUND;
      DBMS_OUTPUT.PUT_LINE(krec.isbn || ' autorstwa ' || krec.autor 
         || ': ' || krec.tytul);
   END LOOP;
   CLOSE kcur;
END;
/

SHOW ERRORS

