REM $Id: ksiazka.pkb,v 1.1 2001/11/30 23:19:50 bill Exp $
REM Z "Nauka Oracle PL/SQL" Rozdzia 5

REM Ciao pakietu "ksiazka" przedstwionego w Rozdziale 5

CREATE OR REPLACE PACKAGE BODY ksiazka
AS
   PROCEDURE dodaj(isbn_in IN VARCHAR2, tytul_in IN VARCHAR2,
      autor_in IN VARCHAR2, liczba_stron_in IN NUMBER, 
      opis_in IN VARCHAR2, data_wydania_in IN DATE,
      id_kodu_kresk_in IN VARCHAR2)
   IS
   BEGIN
      nopu.okresl_nie_null(isbn_in);

      INSERT INTO ksiazki (isbn, tytul, opis, autor, data_wydania,
         liczba_stron)
      VALUES (isbn_in, tytul_in, opis_in, autor_in, data_wydania_in,
         liczba_stron_in);

      IF id_kodu_kresk_in IS NOT NULL
      THEN
         dodaj_egzemplarz(isbn_in, id_kodu_kresk_in);
      END IF;

   END dodaj;

   PROCEDURE dodaj_egzemplarz(isbn_in IN VARCHAR2, id_kodu_kresk_in IN VARCHAR2)
   IS
   BEGIN
      nopu.okresl_nie_null(isbn_in);
      nopu.okresl_nie_null(id_kodu_kresk_in);
      INSERT INTO egzemplarze_ksiazki (isbn, id_kodu_kresk)
      VALUES (isbn_in, id_kodu_kresk_in);
   EXCEPTION
      WHEN DUP_VAL_ON_INDEX
      THEN
         NULL;
   END;

   FUNCTION ilosc_egzemp_ksiazki(isbn_in IN VARCHAR2)
   RETURN NUMBER
   AS
      ilosc_egzemplarzy NUMBER := 0;  /* typ PLS_INTEGER */
      CURSOR ek_cur IS
         SELECT COUNT(*)
           FROM egzemplarze_ksiazki
          WHERE isbn = isbn_in;
   BEGIN
      IF isbn_in IS NOT NULL
      THEN
         OPEN ek_cur;
         FETCH ek_cur INTO ilosc_egzemplarzy;
         CLOSE ek_cur;
      END IF;
      RETURN ilosc_egzemplarzy;
   END;

   PROCEDURE zmien(isbn_in IN VARCHAR2, nowy_tytul IN VARCHAR2,
      nowy_autor IN VARCHAR2, nowa_liczba_stron IN NUMBER,
      nowy_opis IN VARCHAR2 DEFAULT NULL,
      nowa_data_wydania IN DATE DEFAULT NULL)
   IS
   BEGIN
      nopu.okresl_nie_null(isbn_in);
      UPDATE ksiazki
         SET tytul = nowy_tytul, autor = nowy_autor, 
             liczba_stron = nowa_liczba_stron, opis = nowy_opis,
             data_wydania = nowa_data_wydania
       WHERE isbn = isbn_in;
      IF SQL%ROWCOUNT = 0
      THEN
         RAISE NO_DATA_FOUND;
      END IF;
   END zmien;

   PROCEDURE usun_egzemplarz(isbn_in IN VARCHAR2, id_kodu_kresk_in IN VARCHAR2)
   IS
   BEGIN
      nopu.okresl_nie_null(id_kodu_kresk_in);
      nopu.okresl_nie_null(isbn_in);
      DELETE egzemplarze_ksiazki
       WHERE id_kodu_kresk = id_kodu_kresk_in
             AND isbn = isbn_in;
   END usun_egzemplarz;

   PROCEDURE usun(isbn_in IN VARCHAR2)
   IS
   BEGIN
      nopu.okresl_nie_null(isbn_in);
      DELETE egzemplarze_ksiazki WHERE isbn = isbn_in;
      DELETE ksiazki WHERE isbn = isbn_in;
      IF SQL%ROWCOUNT = 0
      THEN
         RAISE NO_DATA_FOUND;
      END IF;
   END usun;

   FUNCTION ksiazka_cur (isbn_in IN VARCHAR2,
      tytul_in IN VARCHAR2,
      autor_in IN VARCHAR2,
      data_wydania_in IN VARCHAR2,
      startrec IN VARCHAR2,
      wierszy_do_pobrania IN VARCHAR2,
      orderby IN VARCHAR2)
      RETURN refcur_t
   IS
      refcur refcur_t;
      wyrazeniewhere VARCHAR2(2048);
      startrec_num PLS_INTEGER;
      wierszy_do_pobrania_num PLS_INTEGER;
   BEGIN
      nopu.tworzwhere(wyrazeniewhere, 'isbn', isbn_in);
      nopu.tworzwhere(wyrazeniewhere, 'tytul', tytul_in);
      nopu.tworzwhere(wyrazeniewhere, 'autor', autor_in);
      nopu.tworzwhere(wyrazeniewhere, 'data_wydania', data_wydania_in,
         'DATE');
      IF startrec IS NOT NULL AND nopu.czy_number(startrec)
      THEN
         startrec_num := TO_NUMBER(startrec);
      ELSE
         startrec_num := 1;
      END IF;

      IF wierszy_do_pobrania IS NOT NULL AND nopu.czy_number(wierszy_do_pobrania)
      THEN
         wierszy_do_pobrania_num := TO_NUMBER(wierszy_do_pobrania);
      ELSE
         wierszy_do_pobrania_num := 1;
      END IF;

      OPEN refcur FOR
         'SELECT isbn, tytul, opis, autor, data_wydania, liczba_stron
            FROM (SELECT a.*, ROWNUM rnum
                    FROM (SELECT * 
                            FROM ksiazki '
                         || wyrazeniewhere || '
                           ORDER BY ' || NVL(orderby,1) || ') a
                   WHERE ROWNUM < :gl) 
           WHERE rnum >= :dl'
         USING startrec_num + wierszy_do_pobrania_num, startrec_num;

      RETURN refcur;
   END;


   FUNCTION egzemp_ksiazki_cur (isbn_in VARCHAR2)
      RETURN refcur_t
   IS
      refcur refcur_t;
   BEGIN
      OPEN refcur FOR
        'SELECT id_kodu_kresk, isbn FROM egzemplarze_ksiazki WHERE isbn = :isbn'
         USING isbn_in;
      RETURN refcur;
   END;

END ksiazka;
/

SHOW ERRORS

