REM $Id: test_ksiazka.pkb,v 1.1 2001/11/30 23:09:49 bill Exp $
REM Z "Nauka Oracle PL/SQL" Rozdzia 3.  Specyfikacja na stronie 98.

REM Ciao pakietu testujcego pakiet "ksiazka"

CREATE OR REPLACE PACKAGE BODY test_ksiazka AS

   ogolny_sukces BOOLEAN := TRUE;
   l_szczegolowo BOOLEAN := TRUE;
   dup_val_sqlcode CONSTANT VARCHAR2(12) := '-1';
   val_err_sqlcode CONSTANT VARCHAR2(12) := '-6502';
   okay_sqlcode CONSTANT VARCHAR2(12) := '0';
   bad_fk_sqlcode CONSTANT VARCHAR2(12) := '-2291';
   no_data_found_sqlcode CONSTANT VARCHAR2(12) := '100';


   /* wygodny zbir wartoci kolumn uywany w rnych testach */

   l_isbn ksiazki.isbn%TYPE := '1-56592-335-9';
   l_tytul ksiazki.tytul%TYPE := 'Programowanie w Oracle PL/SQL';
   l_opis ksiazki.opis%TYPE := 'Podrcznik encyklopedyczny dla programistw PL/SQL, ' ||
       'wraz z przykadami i wskazwkami na temat programowania.';
   l_autor ksiazki.autor%TYPE := 'Feuerstein, Steven, Bill Pribyl';
   l_data_wydania ksiazki.data_wydania%TYPE :=
      TO_DATE('01-WRZ-1997', 'DD-MON-YYYY');
   l_liczba_stron ksiazki.liczba_stron%TYPE := 987;
   l_id_kodu_kresk egzemplarze_ksiazki.id_kodu_kresk%TYPE := '100000001';


   /* ======================================================================
   || Procedury i funkcje narzdziowe. Najpierw bardziej oglne, ktre
   || mog by przeniesione gdziekolwiek (do innego pakietu, w iinym celu).
   */

   PROCEDURE pl(kom IN VARCHAR2, nowy_wiersz IN BOOLEAN DEFAULT TRUE) IS
   BEGIN
      IF l_szczegolowo
      THEN
         IF nowy_wiersz THEN
            DBMS_OUTPUT.PUT_LINE(kom);
         ELSE
            DBMS_OUTPUT.PUT(kom);
         END IF;
      END IF;
   END pl;

   PROCEDURE testrownosci (opis IN VARCHAR2, wartosc_oczekiwana IN VARCHAR2,
      wartosc_otrzymana IN VARCHAR2) IS
   BEGIN
      pl('...' || opis || ': ', nowy_wiersz => FALSE);
      IF wartosc_oczekiwana = wartosc_otrzymana
         OR (wartosc_oczekiwana IS NULL AND wartosc_otrzymana IS NULL)
      THEN
         pl('SUKCES');
      ELSE
         ogolny_sukces := FALSE;
         pl('BD. Oczekiwano ' || wartosc_oczekiwana || '; otrzymano ' || wartosc_otrzymana);
      END IF;
   END;


   FUNCTION moja_to_char (czy_true IN BOOLEAN) RETURN VARCHAR2 IS
   BEGIN
      IF czy_true
      THEN
         RETURN 'TRUE';
      ELSIF NOT czy_true
      THEN
         RETURN 'FALSE';
      ELSE
         RETURN TO_CHAR(NULL);
      END IF;
   END;
      
   
   PROCEDURE testrownosci (opis IN VARCHAR2, wartosc_oczekiwana IN BOOLEAN,
      wartosc_otrzymana IN BOOLEAN) IS
   BEGIN
      testrownosci(opis, moja_to_char(wartosc_oczekiwana),
         moja_to_char(wartosc_otrzymana));
   END testrownosci;


   /* ======================================================================
   || Teraz kilka procedur i funkcji prywatnych, ktre s zwizane z
   || pakietem ksiazki
   */

   FUNCTION ile_ksiazek RETURN NUMBER IS
      ile NUMBER;
   BEGIN
      SELECT COUNT(*) INTO ile FROM ksiazki;
      RETURN ile;
   END;

   FUNCTION ile_egzemp_ksiazek RETURN NUMBER IS
      ile NUMBER;
   BEGIN
      SELECT COUNT(*) INTO ile FROM egzemplarze_ksiazki;
      RETURN ile;
   END;
   
   PROCEDURE dodaj_jedna_ksiazka IS
   BEGIN
      ksiazka.dodaj(isbn_in => l_isbn, id_kodu_kresk_in => l_id_kodu_kresk, 
         tytul_in => l_tytul, opis_in => l_opis, autor_in => l_autor,
         data_wydania_in => l_data_wydania, liczba_stron_in => l_liczba_stron);
   END;


   /* ======================================================================
   || "Sterownik", ktry wykonuje wszystkie testy
   */

   PROCEDURE run(szczegolowo IN BOOLEAN) IS
   BEGIN
      l_szczegolowo := szczegolowo;
      IF l_szczegolowo
      THEN
         DBMS_OUTPUT.PUT_LINE('Testowanie pakietu ksiazka...');
      END IF;
      dodaj;
      dodaj_egzemplarz;
      ilosc_egzemp_ksiazki;
      zmien;
      usun_egzemplarz;
      usun;
      IF ogolny_sukces
      THEN
         DBMS_OUTPUT.PUT_LINE('pakiet ksiazka: SUKCES');
      ELSE
         DBMS_OUTPUT.PUT_LINE('pakiet ksiazka: BD');
      END IF;
         
   END run;

   
   /* ======================================================================
   || Testy kadej funkcji i procedury testowanego pakietu
   */

   PROCEDURE dodaj IS

      CURSOR ksiazkacur IS
         SELECT COUNT(*) FROM ksiazki
          WHERE isbn = l_isbn
            AND tytul = l_tytul
            AND opis = l_opis
            AND autor = l_autor
            AND data_wydania = l_data_wydania
            AND liczba_stron = l_liczba_stron;

      CURSOR egzempcur IS
         SELECT COUNT(*) FROM egzemplarze_ksiazki
          WHERE isbn = l_isbn
            AND id_kodu_kresk = l_id_kodu_kresk;

      ile NUMBER;
      l_sqlcode NUMBER;

   BEGIN

      DELETE egzemplarze_ksiazki;
      DELETE ksiazki;

      /* uruchamia procedur "dodaj", podajc wzystkie dane wejciowe */
      dodaj_jedna_ksiazka;
      
      /* Teraz wykonaie testu z isbn o wartoci NULL w celu sprawdzenia,
      || czy detekcja danych wejciowych dziaa poprawnie. Jeli dziaa,
      || przechwytujemy wyjtek; jeli nie dziaa, zostanie wywietlony
      || komunikat o bdzie. cile mwic, powinnimy powtrzy ten test
      || uywajc id_kodu_kresk o wartoci NULL.
       */

      /* sprwawdzamy, czy isbn o wartoci NULL poprawnie przechwytuje
      || wyjtek
       */

      BEGIN
         ksiazka.dodaj(isbn_in => NULL, id_kodu_kresk_in => 'foo',
            tytul_in => 'foo', opis_in => 'foo', autor_in => 'foo',
            data_wydania_in => SYSDATE, liczba_stron_in => 0);
         l_sqlcode := SQLCODE;
      EXCEPTION
      WHEN OTHERS THEN
         l_sqlcode := SQLCODE;
      END;

      testrownosci('procedura dodaj, wykrywanie wartoci NULL na wejciu',
         val_err_sqlcode, TO_CHAR(l_sqlcode));

      /* czy istnieje jedna i tylko jedna nowa ksika oraz jeden i tylko 
      || jeden nowy egzemplarz ksiki?
      */
      testrownosci('procedura dodaj, liczba rekordw ksiek', '1', TO_CHAR(ile_ksiazek()));
      testrownosci('procedura dodaj, liczba rekordw egzemplarzy',
               '1', TO_CHAR(ile_egzemp_ksiazek()));

      /* czy wstawione rekordy odpowiadaj temu, czego si spodziewamy? */

      OPEN ksiazkacur; FETCH ksiazkacur INTO ile;
      testrownosci('procedura dodaj, pobrane dane o ksice odpowiadaj wstawionym',
               TRUE, ksiazkacur%FOUND);
      CLOSE ksiazkacur;

      OPEN egzempcur; FETCH egzempcur INTO ile;
      testrownosci('procedura dodaj, pobrane dane o egzemplarzu odpowiadaj wstawionym', TRUE,
                 egzempcur%FOUND);
      CLOSE egzempcur;

      /* Upewniamy si, e prba dodania tego samego isbn drugi raz spowoduje
      || przechwycenie wyjtku. Jest to test projektu bazy danych, ale
      || moemy sprawdzi take to.
      */

      BEGIN
         dodaj_jedna_ksiazka;
         l_sqlcode := SQLCODE;
      EXCEPTION
         WHEN OTHERS THEN
            l_sqlcode := SQLCODE;
      END;
      testrownosci('procedura dodaj, wykrywanie duplikatw isbn', dup_val_sqlcode,
               l_sqlcode);

   END dodaj;

   /* ------------------------------------------------------------------- */
   PROCEDURE dodaj_egzemplarz IS
      l_sqlcode NUMBER := 0;
   BEGIN
      DELETE egzemplarze_ksiazki;
      DELETE ksiazki;
      dodaj_jedna_ksiazka;
      DELETE egzemplarze_ksiazki;
      ksiazka.dodaj_egzemplarz(isbn_in => l_isbn, id_kodu_kresk_in => l_id_kodu_kresk);
      testrownosci('procedura dodaj_egzemplarz, przypadek nominalny, pierwsza ksika',
               '1', TO_CHAR(ile_egzemp_ksiazek()));

      ksiazka.dodaj_egzemplarz(isbn_in => l_isbn, id_kodu_kresk_in => '0101010101');
      testrownosci('procedura dodaj_egzemplarz, przypadek nominalny, druga ksika',
               '2', TO_CHAR(ile_egzemp_ksiazek()));

      BEGIN
         ksiazka.dodaj_egzemplarz(isbn_in => l_isbn, id_kodu_kresk_in => l_id_kodu_kresk);
      EXCEPTION
      WHEN OTHERS THEN
         l_sqlcode := SQLCODE;
      END;
      testrownosci('procedura dodaj_egzemplarz, ignorowanie duplikatw',
               okay_sqlcode, TO_CHAR(l_sqlcode));

      BEGIN
         ksiazka.dodaj_egzemplarz(isbn_in => '1234567890', id_kodu_kresk_in => '0202020202');
      EXCEPTION
      WHEN OTHERS THEN
         l_sqlcode := SQLCODE;
      END;
      testrownosci('procedura dodaj_egzemplarz, wykrywanie bdnego isbn',
               bad_fk_sqlcode, TO_CHAR(l_sqlcode));
      

      BEGIN
         ksiazka.dodaj_egzemplarz(isbn_in => NULL, id_kodu_kresk_in => '0303030303');
      EXCEPTION
      WHEN OTHERS THEN
         l_sqlcode := SQLCODE;
      END;
      testrownosci('procedura dodaj_egzemplarz, wykrywanie isbn o wartoci NULL',
               val_err_sqlcode, TO_CHAR(l_sqlcode));

      BEGIN
         ksiazka.dodaj_egzemplarz(isbn_in => 'cokolwiek', id_kodu_kresk_in => NULL);
      EXCEPTION
      WHEN OTHERS THEN
         l_sqlcode := SQLCODE;
      END;
      testrownosci('procedura dodaj_egzemplarz, wykrywanie id_kodu_kresk o wartoci NULL',
               val_err_sqlcode, TO_CHAR(l_sqlcode));
   END dodaj_egzemplarz;

   /* ------------------------------------------------------------------- */
   PROCEDURE ilosc_egzemp_ksiazki IS
   BEGIN
      DELETE egzemplarze_ksiazki;
      DELETE ksiazki;
      dodaj_jedna_ksiazka;
      DELETE egzemplarze_ksiazki;
      testrownosci('funkcja ilosc_egzemp_ksiazki, brak rekordw', '0', 
         TO_CHAR(ksiazka.ilosc_egzemp_ksiazki(l_isbn)));
      ksiazka.dodaj_egzemplarz(isbn_in => l_isbn, id_kodu_kresk_in => l_id_kodu_kresk);
      ksiazka.dodaj_egzemplarz(isbn_in => l_isbn, id_kodu_kresk_in => '0101010101');
      testrownosci('funkcja ilosc_egzemp_ksiazki, wiele rekordw', '2', 
         TO_CHAR(ksiazka.ilosc_egzemp_ksiazki(l_isbn)));
   END;

   /* ------------------------------------------------------------------- */
   PROCEDURE zmien IS
      l_nowy_opis ksiazki.opis%TYPE := 'Duga i nudna ksika o PL/SQL';
      CURSOR zmncur IS
         SELECT COUNT(*) FROM ksiazki
          WHERE isbn = l_isbn
            AND tytul = l_tytul
            AND opis = l_nowy_opis
            AND autor = l_autor
            AND data_wydania = l_data_wydania
            AND liczba_stron = l_liczba_stron;

      ile NUMBER;
      l_sqlcode NUMBER;
   BEGIN
      DELETE egzemplarze_ksiazki;
      DELETE ksiazki;
      dodaj_jedna_ksiazka;

      /* Teraz zmieniamy tylko opis */
      ksiazka.zmien(isbn_in => l_isbn, 
         nowy_opis => l_nowy_opis, nowy_tytul => l_tytul, 
         nowy_autor => l_autor, nowa_data_wydania => l_data_wydania, 
         nowa_liczba_stron => l_liczba_stron);
      OPEN zmncur; FETCH zmncur INTO ile; CLOSE zmncur;
      testrownosci('procedura zmien, test pojedynczego pola', '1', TO_CHAR(ile));

      /* Test isbn o wartoci NULL */
      BEGIN
         ksiazka.zmien(isbn_in => NULL,
         nowy_tytul => l_tytul, nowy_opis => l_opis, nowy_autor => l_autor,
         nowa_data_wydania => l_data_wydania,
            nowa_liczba_stron => l_liczba_stron);
         l_sqlcode := SQLCODE;
      EXCEPTION
      WHEN OTHERS THEN
         l_sqlcode := SQLCODE;
      END;
      testrownosci('procedura zmien, wykrywanie id_kodu_kresk o wartosci NULL',
         val_err_sqlcode, TO_CHAR(l_sqlcode));

   END zmien;

   /* ------------------------------------------------------------------- */
   PROCEDURE usun_egzemplarz IS
      l_sqlcode NUMBER;
   BEGIN
      DELETE egzemplarze_ksiazki;
      DELETE ksiazki;
      dodaj_jedna_ksiazka;
      ksiazka.usun_egzemplarz(id_kodu_kresk_in => l_id_kodu_kresk);
      testrownosci('procedura usun_egzemplarz, liczba ksiek normalna',
               '1', TO_CHAR(ile_ksiazek()));
      testrownosci('procedura usun_egzemplarz, liczba egzemplarzy normalna',
               '0', TO_CHAR(ile_egzemp_ksiazek()));

      /* Jeli usuniemy jeszce raz, powinien wystpi bd. */
      BEGIN
         ksiazka.usun_egzemplarz(id_kodu_kresk_in => l_id_kodu_kresk);
         l_sqlcode := SQLCODE;
      EXCEPTION
         WHEN OTHERS THEN
            l_sqlcode := SQLCODE;
      END;
      testrownosci('procedura usun_egzemplarz, nadmiarowe wywoanie', okay_sqlcode,
         TO_CHAR(l_sqlcode));

   END usun_egzemplarz;

   /* ------------------------------------------------------------------- */
   PROCEDURE usun IS
      l_sqlcode NUMBER;
   BEGIN
      DELETE egzemplarze_ksiazki;
      DELETE ksiazki;
      dodaj_jedna_ksiazka;
      ksiazka.usun(l_isbn);
      testrownosci('procedura usun, liczba ksiek normalna', '0', TO_CHAR(ile_ksiazek()));
      testrownosci('procedura usun, liczba egzemplarzy normalna',
               '0', TO_CHAR(ile_egzemp_ksiazek()));

      /* Jeli usuniemy jeszcze raz, powinien wystpi bd NO_DATA_FOUND. */
      BEGIN
         ksiazka.usun(l_isbn);
         l_sqlcode := SQLCODE;
      EXCEPTION
         WHEN OTHERS THEN
            l_sqlcode := SQLCODE;
      END;
      testrownosci('procedura usun, nadmiarowe wywoanie',
               no_data_found_sqlcode, TO_CHAR(l_sqlcode));

   END usun;

END test_ksiazka;
/

SHOW ERRORS

