REM $Id: wstaw_ksiazki.sql,v 1.1 2001/11/30 23:19:50 bill Exp $
REM Z "Nauka Oracle PL/SQL"

REM Skrypt wstawiajcy rne przykadowe rekordy do tabel ksiazki oraz
REM egzemplarze_ksiazki

REM Uwaga: Trzeba uy komendy SET DEFINE OFF, gdy SQL*Plus przchwyci znaki
REM ampersand (&) przed ich przesaniem do serwera. SQL*Plus zwykle uywa
REM znaku ampersand do oznaczenia zmiennej, ktra wymaga od uytkownika
REM podania wartoci interaktywnie.

SET DEFINE OFF

DECLARE
   PROCEDURE insert_ksiazka_bez_problemow(isbn_in IN VARCHAR2,
      tytul_in IN VARCHAR2, opis_in IN VARCHAR2, autor_in IN VARCHAR2,
      data_wydania_in IN DATE, liczba_stron_in IN NUMBER)
   IS
   BEGIN
      INSERT INTO ksiazki (isbn, tytul, opis, autor, data_wydania,
              liczba_stron)
      VALUES (isbn_in, tytul_in, opis_in, autor_in, data_wydania_in,
              liczba_stron_in);
   EXCEPTION
      WHEN DUP_VAL_ON_INDEX
      THEN
         NULL;
   END;

   PROCEDURE insert_egzemp_bez_problemow(id_kodu_kresk_in IN VARCHAR2,
      isbn_in IN VARCHAR2)
   IS
   BEGIN
      INSERT INTO egzemplarze_ksiazki (id_kodu_kresk, isbn)
      VALUES (id_kodu_kresk_in, isbn_in);
   EXCEPTION
      WHEN DUP_VAL_ON_INDEX
      THEN
         NULL;
   END;

BEGIN

   insert_ksiazka_bez_problemow ('0-596-00180-0',
      'Nauka Oracle PL/SQL',
      'Podrcznik dla pocztkujcych o jzyku PL/SQL systemu Oracle',
      'Bill Pribyl, Steven Feuerstein',
      TO_DATE('29-LIS-2001', 'DD-MON-YYYY'),
      401);

   insert_ksiazka_bez_problemow ('1-56592-335-9',
      'Programowanie w Oracle PL/SQL',
      'Podrcznik encyklopedyczny dla programistw PL/SQL, wraz '
         || 'z ptrzykadami i wskazwkami na temat programowania.',
      'Feuestein, Steven, Bill Pribyl',
      TO_DATE('01-WRZ-1997', 'DD-MON-YYYY'),
      987);

   insert_ksiazka_bez_problemow ('1-56592-457-6',
      'Jzyk Oracle PL/SQL Leksykon kieszonkowy',
      'May leksykon przenaczony dla programistw Oracle PL/SQL. Obejmuje system '
         || 'Oracle8i.',
      'Feuerstein, Steven, Bill Pribyl, Chip Dawes',
      TO_DATE('01-KWI-1999', 'DD-MON-YYYY'),
      94);

   insert_ksiazka_bez_problemow ('0-14071-483-9',
      'Krl Ryszard III',
      'Wspczesne wydanie znanej tragedii historycznej Shakespeare''a, w ktrej  '
         || 'podstpny wadca prbuje przywaszczy sobie koron, lecz ginie pozbawiony '
         || 'w bitwie konia.',
      'Shakespeare, William',
      TO_DATE('01-SIE-2000', 'DD-MON-YYYY'),
      158);

   insert_ksiazka_bez_problemow ('0-14-071415-4',
      'Burza',
      'W tej tajemniczej opowieci o mioci, magii i (w kocu) o przebaczeniu ksi '
         || 'z crk na zaczarowanej wyspie spotykaj byych wrogw.',
      'Shakespeare, William',
      TO_DATE('01-STY-1959', 'DD-MON-YYYY'),
      120);

   insert_ksiazka_bez_problemow ('0-672-31798-2',
      'Naucz si PL/SQL w 21 dni, Drugie wydanie',
      'Podrcznik proceduralnego jzyka systemu Oracle zorganizowany w formie prezentacji '
         || 'zagadnie jzykowych w czasie trzytygodniowego planu nauki.',
      'Gennick, Jonathan, Tom Luers',
      TO_DATE('01-GRU-1999', 'DD-MON-YYYY'),
      692);

   insert_ksiazka_bez_problemow ('0-07-882438-9',
      'Oracle PL/SQL - porady i techniki',
      'Obszerny tom prezentujcy porady, techniki oraz materia referencyjny na temat '
         || 'jzyka PL/SQL systemu Oracle.',
      'Trezzo, Joseph C.',
      TO_DATE('01-LIP-1999', 'DD-MON-YYYY'),
      942);

   insert_ksiazka_bez_problemow ('0-13-794314-8',
      'Tworzenie inteligentnych baz danych z uyciem wyzwalaczy i procedur magazynowanych '
         || 'Oracle PL/SQL - drugie wyd.',
      'Podrcznik programowania w PL/SQL, skupiajcy si na budowaniu komponentw wielokrotnego '
         || 'uycia w duych aplikacjach systemu Oracle.',
      'Owens, Kevin T.',
      TO_DATE('01-CZE-1999', 'DD-MON-YYYY'),
      544);

   insert_ksiazka_bez_problemow ('1-56592-674-9',
      'Podrcznik programisty Oracle PL/SQL',
      'wiczenuia dla pocztkujcych, rednio i wysoko zaawansowanych sprawdzajce wiedz '
         || 'czytelnika na temat jzyka programowania systemu Oracle PL/SQL.',
      'Feuerstein, Steven, Andrew Odewahn',
      TO_DATE('01-MAJ-1999', 'DD-MON-YYYY'),
      588);


   insert_egzemp_bez_problemow ('92644384', '0-596-00180-0');
   insert_egzemp_bez_problemow ('92644385', '0-596-00180-0');
   insert_egzemp_bez_problemow ('92644386', '0-596-00180-0');
   insert_egzemp_bez_problemow ('89679588', '1-56592-335-9');
   insert_egzemp_bez_problemow ('89679589', '1-56592-335-9');
   insert_egzemp_bez_problemow ('29846701', '1-56592-457-6');
   insert_egzemp_bez_problemow ('29846702', '1-56592-457-6');
   insert_egzemp_bez_problemow ('29846703', '1-56592-457-6');
   insert_egzemp_bez_problemow ('12983106', '0-14-071415-4');

END;
/

COMMIT;

SET DEFINE ON

