REM $Id: proste_pobranie_w_petli.sql,v 1.1 2001/11/30 23:19:51 bill Exp $
REM Z "Nauka Oracle PL/SQL" strona 160

REM Ilustruje proste pobranie danych w ptli

DECLARE
   tytul_ulubionej_sztuki VARCHAR2(200);
   data_opublikowania DATE;

   CURSOR kcur
       IS SELECT tytul, data_wydania
     FROM ksiazki
    WHERE UPPER(autor) LIKE 'SHAKESPEARE%';

BEGIN
   OPEN kcur;
   LOOP
      FETCH kcur INTO tytul_ulubionej_sztuki,
         data_opublikowania;
      EXIT WHEN kcur%NOTFOUND;
      DBMS_OUTPUT.PUT_LINE(kcur%ROWCOUNT
         || ') ' || tytul_ulubionej_sztuki
         || ', opublikowano w '
         || TO_CHAR(data_opublikowania, 'YYYY'));
   END LOOP;
   CLOSE kcur;
END;
/

