REM $Id: nopu.pks,v 1.1 2001/11/30 23:19:50 bill Exp $
REM Z "Nauka Oracle PL/SQL" Rozdzia 5

REM Specyfikacja wersji pakietu nopu, ktra dodaje programy z rozdz05.

CREATE OR REPLACE PACKAGE nopu
AS
   koniec_wiersza CONSTANT VARCHAR2(1) := CHR(10);

   SUBTYPE sqlboolean IS VARCHAR2(1);
   sqltrue CONSTANT sqlboolean := 'T';
   sqlfalse CONSTANT sqlboolean := 'F';

   PROCEDURE ustaw_dflt_date_format(format_daty IN VARCHAR2);

   FUNCTION dflt_date_format
      RETURN VARCHAR2;

   FUNCTION czy_lancuch (cos IN VARCHAR2)
      RETURN BOOLEAN;

   FUNCTION czy_number (cos IN VARCHAR2)
      RETURN BOOLEAN;

   FUNCTION czy_date (cos IN VARCHAR2,
      format_daty IN VARCHAR2 DEFAULT dflt_date_format)
      RETURN BOOLEAN;

   PROCEDURE okresl (
      warunek_in IN BOOLEAN,
      komunikat_in IN VARCHAR2,
      wyjatek_in IN PLS_INTEGER);

   PROCEDURE okresl (
      warunek_in IN BOOLEAN,
      komunikat_in IN VARCHAR2,
      wyjatek_in IN VARCHAR2 DEFAULT 'VALUE_ERROR');

   PROCEDURE okresl_nie_null (zmienna_testowana IN VARCHAR2,
      error_kom IN VARCHAR2 DEFAULT NULL);
   PROCEDURE okresl_nie_null (zmienna_testowana IN NUMBER,
      error_kom IN VARCHAR2 DEFAULT NULL);
   PROCEDURE okresl_nie_null (zmienna_testowana IN DATE,
      error_kom IN VARCHAR2 DEFAULT NULL);

   FUNCTION lanc_pasuje (cos IN VARCHAR2,
      min_dlugosc IN NUMBER,
      max_dlugosc IN NUMBER)
      RETURN BOOLEAN;

   PROCEDURE tworzwhere (wyrazenie_where IN OUT VARCHAR2,
      nazwa_kolumny IN VARCHAR2, wartosc_kolumny IN VARCHAR2,
      typ_danych IN VARCHAR2 DEFAULT 'STRING',
      format_danych IN VARCHAR2 DEFAULT NULL,
      przepisz_op IN BOOLEAN DEFAULT TRUE);

   FUNCTION esc (tekst IN VARCHAR2)
      RETURN VARCHAR2;

END nopu;
/

SHOW ERRORS

