REM $Id: dodaj_ksiazke.pro,v 1.1 2001/11/30 23:09:48 bill Exp $
REM Z "Nauka Oracle PL/SQL" strona 71

REM Procedura dodajca rekord(y) do tabel ksiazki oraz egzemplarze_ksiazki

CREATE OR REPLACE PROCEDURE dodaj_ksiazke (isbn_in IN VARCHAR2,
   id_kodu_kresk_in IN VARCHAR2, tytul_in IN VARCHAR2, autor_in IN VARCHAR2,
   liczba_stron_in IN NUMBER, opis_in IN VARCHAR2 DEFAULT NULL,
   data_wydania_in IN DATE DEFAULT NULL)
AS
BEGIN
   /* spawd, czy dane wejciowe s poprawne */

   IF isbn_in IS NULL
   THEN
      RAISE VALUE_ERROR;
   END IF;

   /* dodaj rekord do tabeli "ksiazki" */

   INSERT INTO ksiazki (isbn, tytul, opis, autor, data_wydania, liczba_stron)
   VALUES (isbn_in, tytul_in, opis_in, autor_in, data_wydania_in,
      liczba_stron_in);

   /* wstaw rekord do tabeli "egzemplarze_ksiazki" */

   IF id_kodu_kresk_in IS NOT NULL
   THEN
      INSERT INTO egzemplarze_ksiazki (isbn, id_kodu_kresk)
      VALUES (isbn_in, id_kodu_kresk_in);
   END IF;

END dodaj_ksiazke;
/

SHOW ERRORS

