REM $Id: uprawnweb.pkb,v 1.1 2001/11/30 23:24:55 bill Exp $
REM Z "Nauka Oracle PL/SQL" strona 343

REM Ciao pakietu zapewniajcego obsug identyfikatora sesji (wspiera 
REM interfejs programw opartych na sieci web)

CREATE OR REPLACE PACKAGE BODY uprawnweb
AS

   timeout_minuty_pryw PLS_INTEGER := 120;

   FUNCTION web_sesja_timeout_minuty RETURN PLS_INTEGER
   IS
   BEGIN
      RETURN timeout_minuty_pryw;
   END;

   FUNCTION id_nowej_sesji(nazwa_uzytk_in IN uzytk_bibl.nazwa_uzytk%TYPE,
      zwyklytekst_haslo_in IN VARCHAR2)
   RETURN VARCHAR2
   IS
      CURSOR idcur (ktory_id VARCHAR2)
      IS
         SELECT NULL
           FROM web_sesje
          WHERE id = ktory_id;
      idrow idcur%ROWTYPE;

      l_id_sesji web_sesje.id%TYPE;
      l_id_uzytk uzytk_bibl.id%TYPE;
      id_istnieje BOOLEAN;

   BEGIN

      /* asercje wartici rnych od NULL okrelone w wywoaniu funkcji
      |  id_uzytk_zidentyfikowanego
      */
      l_id_uzytk :=
         uzytkbibl.id_uzytk_zidentyfikowanego(nazwa_uzytk_in, zwyklytekst_haslo_in);

      /* Wyszukiwanie w ptli w celu zapewnienia, e identyfikator sesji jest
      |  niepowtarzalny. Jest to mao prawdopodobne, ale nidgy nie wiadomo...
      */

      WHILE id_istnieje IS NULL OR id_istnieje 
      LOOP
         l_id_sesji := nopu.losowy_lanc;
         OPEN idcur(l_id_sesji);
         FETCH idcur INTO idrow;
         IF idcur%FOUND
         THEN
            id_istnieje := TRUE;
         ELSE
            id_istnieje := FALSE;
         END IF;
         CLOSE idcur;
      END LOOP;

      INSERT INTO web_sesje(id, id_uzytk,
                  data_wygasniecia)
      VALUES (l_id_sesji, l_id_uzytk,
                  SYSDATE + (web_sesja_timeout_minuty/1440));
      RETURN l_id_sesji;

   END id_nowej_sesji;

   FUNCTION id_uzytk (id_sesji_in IN web_sesje.id%TYPE)
      RETURN PLS_INTEGER
   IS
      CURSOR scur
      IS
         SELECT id_uzytk, data_wygasniecia
           FROM web_sesje
          WHERE id = id_sesji_in;
      srow scur%ROWTYPE;
   BEGIN

      IF id_sesji_in IS NULL
      THEN
         exc.mojeraise(exc.nie_zalogowany_cd);
      END IF;

      OPEN scur;
      FETCH scur INTO srow;
      IF scur%NOTFOUND
      THEN
         CLOSE scur;
         exc.mojeraise(exc.nie_zalogowany_cd);
      END IF;
      CLOSE scur;

      IF srow.data_wygasniecia < SYSDATE
      THEN
         exc.mojeraise(exc.sesja_zakonczona_cd);
      END IF;

      RETURN srow.id_uzytk;

   END id_uzytk;

   PROCEDURE dostep_dozwolony (id_sesji IN web_sesje.id%TYPE,
         id_uprawn IN uprawnienia_bibl.id%TYPE)
   IS
   BEGIN
      /* asercje wartoci rnych od NULL okrelone w nastpnej instrukcji */
      uprawn.dostep_dozwolony(id_uzytk(id_sesji), id_uprawn);
   END dostep_dozwolony;

END uprawnweb;
/

SHOW ERRORS

