REM $Id: aktywni_czytelnicy.fun,v 1.1 2001/11/30 23:24:55 bill Exp $
REM Z "Nauka Oracle PL/SQL" strona 357

REM Ilustracja "potokowej funkcji tabeli", ktra zwraca "wiersze potokowe",
REM z ktrych mona pobiera dane (patrz dodatkowy plik, potoki_demo.sql)

CREATE OR REPLACE FUNCTION aktywni_czytelnicy (data_rozp DATE DEFAULT SYSDATE - 14)
   RETURN aktywni_czytelnicy_t
   PIPELINED
AS
BEGIN
   FOR czyt IN 
       (SELECT id FROM uzytk_bibl u, czytelnik_egz_ks_zdarzenia z
         WHERE u.id = z.id_czytelnika
           AND znacznik_czasu > data_rozp)
   LOOP
      PIPE ROW (czyt.id);
   END LOOP;
   RETURN;
END;
/

SHOW ERRORS

