REM $Id: nopu.pkb,v 1.1 2001/11/30 23:19:50 bill Exp $
REM Z "Nauka Oracle PL/SQL" strona 175

REM Ciao pakietu oglnego przenaczenia przedstawionego w Rozdziale 5

REM Uwaga: Numery linii nie zgadzaj si z podanymi w ksice

CREATE OR REPLACE PACKAGE BODY nopu
AS
   koniec_wiersza CONSTANT VARCHAR2(1) := CHR(10);
   dflt_date_format_private nls_session_parameters.value%TYPE;

   PROCEDURE ustaw_dflt_date_format(format_daty IN VARCHAR2)
   IS
   BEGIN
      dflt_date_format_private := format_daty;
   END;

   FUNCTION dflt_date_format
      RETURN VARCHAR2
   IS
   BEGIN
      RETURN dflt_date_format_private;
   END;

   FUNCTION czy_lancuch (cos IN VARCHAR2)
      RETURN BOOLEAN
   IS
   BEGIN
      RETURN TRUE;
   END;

   FUNCTION czy_number (cos IN VARCHAR2)
      RETURN BOOLEAN
   IS
      testerliczby NUMBER;
   BEGIN
      testerliczby := TO_NUMBER(cos);
      RETURN TRUE;
   EXCEPTION
      WHEN OTHERS
      THEN
         RETURN FALSE;
   END;

   FUNCTION czy_date (cos IN VARCHAR2,
      format_daty IN VARCHAR2 DEFAULT dflt_date_format)
      RETURN BOOLEAN
   IS
      testerdaty DATE;
   BEGIN
      testerdaty := TO_DATE(cos, format_daty);
      RETURN TRUE;
   EXCEPTION
      WHEN OTHERS
      THEN
         RETURN FALSE;
   END;

   PROCEDURE okresl (
      warunek_in IN BOOLEAN,
      komunikat_in IN VARCHAR2,
      wyjatek_in IN PLS_INTEGER)
   IS
   BEGIN
      IF NOT warunek_in
         OR warunek_in IS NULL
      THEN
         exc.mojeraise(wyjatek_in, komunikat_in);
      END IF;
   END okresl;

   PROCEDURE okresl (
      warunek_in IN BOOLEAN,
      komunikat_in IN VARCHAR2,
      wyjatek_in IN VARCHAR2)
   IS
   BEGIN
      IF NOT warunek_in
         OR warunek_in IS NULL
      THEN
         EXECUTE IMMEDIATE
           'BEGIN RAISE ' || wyjatek_in || '; END;';
      END IF;
   END okresl;

   PROCEDURE okresl_nie_null (zmienna_testowana IN VARCHAR2,
      error_kom IN VARCHAR2)
   IS
   BEGIN
      IF zmienna_testowana IS NULL
      THEN
         exc.mojeraise(exc.brak_wartosci_cd, error_kom);
      END IF;
   END okresl_nie_null;

   PROCEDURE okresl_nie_null (zmienna_testowana IN DATE,
      error_kom IN VARCHAR2)
   IS
   BEGIN
      okresl_nie_null(TO_CHAR(zmienna_testowana, error_kom));
   END;

   PROCEDURE okresl_nie_null (zmienna_testowana IN NUMBER,
      error_kom IN VARCHAR2)
   IS
   BEGIN
      okresl_nie_null(TO_CHAR(zmienna_testowana, nopu.dflt_date_format),
         error_kom);
   END;

   FUNCTION lanc_pasuje (cos IN VARCHAR2,
      min_dlugosc IN NUMBER,
      max_dlugosc IN NUMBER)
      RETURN BOOLEAN
   IS
      dlugosc_cos NUMBER := LENGTH(cos);
   BEGIN
      IF (cos IS NULL AND min_dlugosc = 0)
         OR
            (dlugosc_cos >= min_dlugosc
            AND
            dlugosc_cos <= max_dlugosc)
      THEN
         RETURN TRUE;
      ELSE
         RETURN FALSE;
      END IF;
   END lanc_pasuje;

   PROCEDURE tworzwhere (wyrazenie_where IN OUT VARCHAR2,
      nazwa_kolumny IN VARCHAR2, wartosc_kolumny IN VARCHAR2,
      typ_danych IN VARCHAR2,
      format_danych IN VARCHAR2,
      przepisz_op IN BOOLEAN)
   IS
      operator_l VARCHAR2(7);
      prs VARCHAR2(1024) := wartosc_kolumny;
   BEGIN
      /* musi by podana zarwno nazwa jak i warto kolumny */
      IF nazwa_kolumny IS NULL OR wartosc_kolumny IS NULL
      THEN
         RETURN;
      END IF;

      IF przepisz_op
      THEN
         operator_l := '=';
      END IF;

      IF wyrazenie_where IS NULL
      THEN
         wyrazenie_where := 'WHERE ';
      ELSE
         wyrazenie_where := wyrazenie_where || ' AND ';
      END IF;

      IF typ_danych = 'STRING'
      THEN
         prs := esc(wartosc_kolumny);

         IF przepisz_op AND INSTR(wartosc_kolumny, '%') != 0
         THEN
            operator_l := ' LIKE ';
         END IF;

      ELSIF typ_danych = 'DATE'
      THEN
         prs := 'TO_DATE(' || esc(wartosc_kolumny) || ','
                           || esc(NVL(format_danych, dflt_date_format))
                    || ')';
      END IF;

      wyrazenie_where := wyrazenie_where || nazwa_kolumny || operator_l || prs;
   END;

   FUNCTION esc (tekst IN VARCHAR2)
      RETURN VARCHAR2
   AS
   BEGIN
      RETURN '''' || REPLACE(tekst, '''', '''''') || '''';
   END;

BEGIN

   /* Ta sekcja pakietu jest wykonywana automatycznie, gdy wywoywana jest
   || po raz pierwszy ktra cz pakietu.  Mona uy jej wic do
   || inicjalizowania zmiennych.  (Patrz strona 321.)
   */

   SELECT VALUE INTO dflt_date_format_private
     FROM NLS_SESSION_PARAMETERS
    WHERE PARAMETER = 'NLS_DATE_FORMAT';

EXCEPTION
   WHEN OTHERS
   THEN NULL;

END nopu;
/

SHOW ERRORS

