REM $Id: ksiazkaweb.pkb,v 1.1 2001/11/30 23:20:19 bill Exp $
REM Z "Nauka Oracle PL/SQL" Rozdzia 4

REM Ostateczna wersja ciaa pakietu ksiazkaweb z Rozdziau 4; zawiera
REM kod sterujcy obsug interfejsu uytkownika

CREATE OR REPLACE PACKAGE BODY ksiazkaweb
AS
   FUNCTION weryfikuj (isbn IN VARCHAR2,
      tytul IN VARCHAR2 DEFAULT NULL,
      autor IN VARCHAR2 DEFAULT NULL,
      liczba_stron_lanc IN VARCHAR2 DEFAULT NULL,
      opis IN VARCHAR2 DEFAULT NULL,
      rrrr_wydania IN VARCHAR2 DEFAULT NULL,
      mies_wydania IN VARCHAR2 DEFAULT NULL,
      dd_wydania IN VARCHAR2 DEFAULT NULL,
      id_kodu_kresk IN VARCHAR2 DEFAULT NULL)
   RETURN ksiazkarec_t
   IS
      fk ksiazkarec_t;
   BEGIN

      fk.isbn := SUBSTR(isbn, 1, 13);
      fk.autor := SUBSTR(autor, 1, 200);
      fk.tytul := SUBSTR(tytul, 1, 200);
      fk.opis := SUBSTR(opis, 1, 2000);
      fk.liczba_stron_lanc := SUBSTR(liczba_stron_lanc, 1, 40);
      fk.rrrr_wydania := SUBSTR(rrrr_wydania, 1, 4);
      fk.mies_wydania := SUBSTR(mies_wydania, 1, 3);
      fk.dd_wydania := SUBSTR(dd_wydania, 1, 2);
      fk.id_kodu_kresk := SUBSTR(id_kodu_kresk, 1, 40);

      fk.poprawnie := nopu.sqltrue;

      IF NOT nopu.lanc_pasuje(isbn,10,13)
      THEN
         fk.isbn_kom := 'Musi mie 10 do 13 znakw';
         fk.poprawnie := nopu.sqlfalse;
      END IF;

      IF NOT nopu.lanc_pasuje(autor,0,200)
      THEN
         fk.autor_kom := 'Musi mie mniej ni 200 znakw';
         fk.poprawnie := nopu.sqlfalse;
      END IF;

      IF NOT nopu.lanc_pasuje(tytul, 0, 200)
      THEN
         fk.tytul_kom := 'Musi mie mniej ni 200 znakw';
         fk.poprawnie := nopu.sqlfalse;
      END IF;

      IF NOT nopu.lanc_pasuje(opis, 0, 2000)
      THEN
         fk.opis_kom := 'Musi mie mniej ni 2000 znakw';
         fk.poprawnie := nopu.sqlfalse;
      END IF;

      IF nopu.czy_number(liczba_stron_lanc)
      THEN
         fk.liczba_stron := TO_NUMBER(liczba_stron_lanc);
         fk.liczba_stron_lanc := TO_CHAR(fk.liczba_stron);
      ELSE
         fk.liczba_stron_kom := 'Musi by liczb';
         fk.poprawnie := nopu.sqlfalse;
      END IF;

      IF nopu.czy_data(rrrr_wydania || mies_wydania || dd_wydania)
      THEN
         fk.data_wydania := TO_DATE(
            rrrr_wydania || mies_wydania || dd_wydania,
            nopu.dflt_date_format);
         fk.rrrr_wydania := TO_CHAR(fk.data_wydania, 'YYYY');
         fk.mies_wydania := TO_CHAR(fk.data_wydania, 'MON');
         fk.dd_wydania := TO_CHAR(fk.data_wydania, 'DD');
      ELSE
         fk.data_wydania_kom := 'Musi by poprawn dat';
         fk.poprawnie := nopu.sqlfalse;
      END IF;

      IF NOT nopu.lanc_pasuje(id_kodu_kresk, 0, 10)
      THEN
         fk.id_kodu_kresk_kom := 'Musi by krtszy ni 11 znakw';
      END IF;

      RETURN fk;

   END weryfikuj;


   FUNCTION przetworz_wpisy (
      wyslij IN VARCHAR2,
      isbn IN VARCHAR2,
      tytul IN VARCHAR2,
      autor IN VARCHAR2,
      liczba_stron IN VARCHAR2,
      opis IN VARCHAR2,
      rrrr_wydania IN VARCHAR2,
      mies_wydania IN VARCHAR2,
      dd_wydania IN VARCHAR2,
      id_kodu_kresk IN VARCHAR2
      )
   RETURN ksiazkarec_t
   IS
      fk ksiazkarec_t;
   BEGIN
      nopu.ustaw_dflt_date_format('YYYYMONDD');

      IF wyslij IS NOT NULL
      THEN
         fk := weryfikuj(isbn, tytul, autor, liczba_stron, opis,
                      rrrr_wydania, mies_wydania, dd_wydania,
                      id_kodu_kresk);

         IF fk.poprawnie = nopu.sqltrue
         THEN
            BEGIN
               ksiazka.dodaj(isbn_in => fk.isbn, id_kodu_kresk_in => fk.id_kodu_kresk,
                    tytul_in => fk.tytul, autor_in => fk.autor,
                    liczba_stron_in => fk.liczba_stron, opis_in => fk.opis,
                    data_wydania_in => fk.data_wydania);

               fk.action_kom := 'Dodano ' || fk.isbn || ' do bazy danych.';

            EXCEPTION
               WHEN DUP_VAL_ON_INDEX
               THEN
                  fk.poprawnie := nopu.sqlfalse;
                  fk.action_kom := 'Bd: Ksika ' || fk.isbn
                     || ' ju istnieje.';

               WHEN OTHERS
               THEN
                  fk.poprawnie := nopu.sqlfalse;
                  fk.action_kom := 'Prba dodania ' || fk.isbn
                     || ' do bazy danych' || ' zakoczona bdem ' || SQLERRM;
            END;
         ELSE
            fk.action_kom := 'Zmian nie zapisano.';
         END IF;

      END IF;

      RETURN fk;

    END przetworz_wpisy;

END ksiazkaweb;
/
SHOW ERRORS

