REM $Id: ksiazka.pkb,v 1.1 2001/11/30 23:09:48 bill Exp $
REM Z "Nauka Oracle PL/SQL" strona 92

REM Ciao pakietu ksiazka

CREATE OR REPLACE PACKAGE BODY ksiazka
AS
   /* "prywatna" procedura do uycia tylko w ciele tego pakietu */
   PROCEDURE okresl_nie_null (testowana_zmienna IN VARCHAR2)
   IS
   BEGIN
      IF testowana_zmienna IS NULL
      THEN
         RAISE VALUE_ERROR;
      END IF;
   END okresl_nie_null;
   
   FUNCTION ilosc_egzemp_ksiazki(isbn_in IN VARCHAR2)
   RETURN NUMBER
   AS
      ilosc_egzemplarzy NUMBER := 0;  /* typ PLS_INTEGER */
      CURSOR ek_cur IS
         SELECT COUNT(*)
           FROM egzemplarze_ksiazki
          WHERE isbn = isbn_in;
   BEGIN
      IF isbn_in IS NOT NULL
      THEN
         OPEN ek_cur;
         FETCH ek_cur INTO ilosc_egzemplarzy;
         CLOSE ek_cur;
      END IF;
      RETURN ilosc_egzemplarzy;
   END;

   PROCEDURE dodaj(isbn_in IN VARCHAR2, tytul_in IN VARCHAR2,
      autor_in IN VARCHAR2, liczba_stron_in IN NUMBER, 
      opis_in IN VARCHAR2, data_wydania_in IN DATE,
      id_kodu_kresk_in IN VARCHAR2)
   IS
   BEGIN
      okresl_nie_null(isbn_in);

      INSERT INTO ksiazki (isbn, tytul, opis, autor, data_wydania,
         liczba_stron)
      VALUES (isbn_in, tytul_in, opis_in, autor_in, data_wydania_in,
         liczba_stron_in);

      IF id_kodu_kresk_in IS NOT NULL
      THEN
         dodaj_egzemplarz(isbn_in, id_kodu_kresk_in);
      END IF;

   END dodaj;

   PROCEDURE dodaj_egzemplarz(isbn_in IN VARCHAR2, id_kodu_kresk_in IN VARCHAR2)
   IS
   BEGIN
      okresl_nie_null(isbn_in);
      okresl_nie_null(id_kodu_kresk_in);
      INSERT INTO egzemplarze_ksiazki (isbn, id_kodu_kresk)
      VALUES (isbn_in, id_kodu_kresk_in);
   EXCEPTION
      WHEN DUP_VAL_ON_INDEX
      THEN
         NULL;
   END;

   PROCEDURE zmien(isbn_in IN VARCHAR2, nowy_tytul IN VARCHAR2,
      nowy_autor IN VARCHAR2, nowa_liczba_stron IN NUMBER,
      nowy_opis IN VARCHAR2 DEFAULT NULL,
      nowa_data_wydania IN DATE DEFAULT NULL)
   IS
   BEGIN
      okresl_nie_null(isbn_in);
      UPDATE ksiazki
         SET tytul = nowy_tytul, autor = nowy_autor, 
             liczba_stron = nowa_liczba_stron, opis = nowy_opis,
             data_wydania = nowa_data_wydania
       WHERE isbn = isbn_in;
      IF SQL%ROWCOUNT = 0
      THEN
         RAISE NO_DATA_FOUND;
      END IF;
   END zmien;

   PROCEDURE usun_egzemplarz(id_kodu_kresk_in IN VARCHAR2)
   IS
   BEGIN
      okresl_nie_null(id_kodu_kresk_in);
      DELETE egzemplarze_ksiazki
       WHERE id_kodu_kresk = id_kodu_kresk_in;
   END usun_egzemplarz;

   PROCEDURE usun(isbn_in IN VARCHAR2)
   IS
   BEGIN
      okresl_nie_null(isbn_in);
      DELETE egzemplarze_ksiazki WHERE isbn = isbn_in;
      DELETE ksiazki WHERE isbn = isbn_in;
      IF SQL%ROWCOUNT = 0
      THEN
         RAISE NO_DATA_FOUND;
      END IF;
   END usun;

END ksiazka;
/

SHOW ERRORS

