-- Ten skrypt pokazuje uycie kursorw bez ograniczenia

SET SERVEROUTPUT ON

DECLARE
  -- deklaracja typu REF CURSOR o nazwie t_cursor (nie ma on zwracanego typu,
  -- wic moe uruchomi dowolne zapytanie)
  TYPE t_cursor IS REF CURSOR;

  -- deklaracja obiektu v_cursor typu t_cursor
  v_cursor t_cursor;

  -- deklaracja obiektu v_product (typu products%ROWTYPE), 
  -- w ktrym bd przechowywane kolumny z tabeli products
  v_product products%ROWTYPE;

  -- deklaracja obiektu v_customer (typu customers%ROWTYPE), 
  -- w ktrym bd przechowywane kolumny z tabeli customers
  v_customer customers%ROWTYPE;
BEGIN
  -- przypisanie zapytania kursorowi v_cursor i otwarcie go za pomoc OPEN FOR
  OPEN v_cursor FOR
  SELECT * FROM products WHERE product_id < 5;
  
  -- uycie ptli do pobrania wierszy z v_cursor do v_product
  LOOP
    FETCH v_cursor INTO v_product;
    EXIT WHEN v_cursor%NOTFOUND;
    DBMS_OUTPUT.PUT_LINE(
      'product_id = ' || v_product.product_id ||
      ', name = ' || v_product.name ||
      ', price = ' || v_product.price
    );
  END LOOP;
  
  -- przypisanie nowego zapytania kursorowi v_cursor i otwarcie go za pomoc OPEN FOR
  OPEN v_cursor FOR
  SELECT * FROM customers WHERE customer_id < 3;
  
  -- uycie ptli do pobrania wierszy z v_cursor do v_customer
  LOOP
    FETCH v_cursor INTO v_customer;
    EXIT WHEN v_cursor%NOTFOUND;
    DBMS_OUTPUT.PUT_LINE(
      'customer_id = ' || v_customer.customer_id ||
      ', first_name = ' || v_customer.first_name ||
      ', last_name = ' || v_customer.last_name
    );
  END LOOP;

  -- zamknicie v_cursor
  CLOSE v_cursor;
END;
/
