-- product_cursor.sql wywietla, korzystajc z kursora, wartoci kolumn
-- product_id, name i price tabeli products

SET SERVEROUTPUT ON

DECLARE
  -- krok 1: deklaracja zmiennych
  v_product_id products.product_id%TYPE;
  v_name       products.name%TYPE;
  v_price      products.price%TYPE;

  -- krok 2: deklaracja kursora
  CURSOR v_product_cursor IS
    SELECT product_id, name, price
    FROM products
    ORDER BY product_id;
BEGIN
  -- krok 3: otwarcie kursora
  OPEN v_product_cursor;
  
  LOOP
  -- krok 4: pobieranie wierszy z kursora
    FETCH v_product_cursor
    INTO v_product_id, v_name, v_price;
  
    -- przerwij ptl, gdy nie ma wicej wierszy, na co wskazuje
    -- zmienna boolowska v_product_cursor%NOTFOUND (=true, jeeli nie ma wicej wierszy)
    EXIT WHEN v_product_cursor%NOTFOUND;
    
    -- uyj DBMS_OUTPUT.PUT_LINE() do wywietlenia zmiennych
    DBMS_OUTPUT.PUT_LINE(
      'v_product_id = ' || v_product_id || ', v_name = ' || v_name ||
      ', v_price = ' || v_price
    );
  END LOOP;

  -- krok 5: zamknicie kursora
  CLOSE v_product_cursor;
END;
/
