-- product_cursor3.sql wywietla wartoci kolumn product_id, name,
-- i price tabeli product, korzystajc ze zmiennej kursora oraz instrukcji OPEN-FOR 

SET SERVEROUTPUT ON

DECLARE
  -- deklaracja typu REF CURSOR o nazwie t_product_cursor
  TYPE t_product_cursor IS
  REF CURSOR RETURN products%ROWTYPE;

  -- deklaracja obiektu t_product_cursor o nazwie v_product_cursor
  v_product_cursor t_product_cursor;
 
  -- deklaracja obiektu v_product (typu products%ROWTYPE),
  -- w ktrym bd przechowywane wartoci kolumn tabeli products
  v_product products%ROWTYPE;
BEGIN
  -- przypisanie zapytania do v_product_cursor 
  -- i otwarcie kursora za pomoc instrukcji OPEN-FOR
  OPEN v_product_cursor FOR
  SELECT * FROM products WHERE product_id < 5;

  -- ptla pobierajca wiersze z v_product_cursor do v_product
  LOOP
    FETCH v_product_cursor INTO v_product;
    EXIT WHEN v_product_cursor%NOTFOUND;
    DBMS_OUTPUT.PUT_LINE(
      'product_id = ' || v_product.product_id ||
      ', name = ' || v_product.name ||
      ', price = ' || v_product.price
    );
  END LOOP;

  -- zamknicie kursora v_product_cursor
  CLOSE v_product_cursor;
END;
/
