-- Ten skrypt SQL*Plus (object_schema3.sql):
--   1. Tworzy uytkownika object_user
--   2. Tworzy baz danych object 
--   3. Wypenia baz danych przykadowymi danymi
--   4. Tworzy kod PL/SQL

-- usunicie uytkownika object_user3 jeeli istnieje.
-- To polecenie moe zwrci bd jeli uytkownik nie istnieje; nie naley si tym przejmowa.
DROP USER object_user3 CASCADE;

-- utworzenie uytkownika object_user3
CREATE USER object_user3 IDENTIFIED BY object_password;

-- nadanie uprawnie uytkownikowi object_user3 do czenia i tworzenia obiektw bazy danych
GRANT connect, resource, create public synonym TO object_user3;

-- przydzielenie uytkownikowi miejsca w przestrzeni tabel users
ALTER USER object_user3 QUOTA 10M ON users;

-- poczenie jako uytkownik object_user3
CONNECT object_user3/object_password;

-- tworzenie typw obiektowych
CREATE TYPE t_person AS OBJECT (
  id INTEGER,
  first_name VARCHAR2(10),
  last_name VARCHAR2(10),
  MEMBER FUNCTION display_details RETURN VARCHAR2
) NOT FINAL;
/

CREATE TYPE BODY t_person AS
  MEMBER FUNCTION display_details RETURN VARCHAR2 IS
  BEGIN
    RETURN 'id=' || id ||
      ', name=' || first_name || ' ' || last_name;
  END;
END;
/

CREATE TYPE t_business_person UNDER t_person (
  title VARCHAR2(20),
  company VARCHAR2(20),
  OVERRIDING MEMBER FUNCTION display_details RETURN VARCHAR2
);

/
CREATE TYPE BODY t_business_person AS
  OVERRIDING MEMBER FUNCTION display_details RETURN VARCHAR2 IS
  BEGIN
    -- uycie uoglnionego wywoania w celu wywoania display_details()
    -- z t_person
    RETURN (SELF AS t_person).display_details ||
      ', title=' || title || ', company=' || company;
   END;
END;
/

-- tworzenie tabeli
CREATE TABLE object_business_customers OF t_business_person;

-- wstawianie przykadowych wierszy
INSERT INTO object_business_customers VALUES (
  t_business_person(1, 'Jan', 'Brzowy', 'Kierownik', 'XYZ SA')
);



-- zatwierdza transakcj
COMMIT;
