-- Ten skrypt SQL*Plus (object_schema.sql):
--   1. Tworzy uytkownika object_user2
--   2. Tworzy baz danych 
--   3. Wypenia baz danych przykadowymi danymi
--   4. Tworzy kod PL/SQL

-- usunicie uytkownika object_user2 jeeli istnieje.
-- To polecenie moe zwrci bd jeli uytkownik nie istnieje; nie naley si tym przejmowa.
DROP USER object_user2 CASCADE;

-- utworzenie uytkownika object_user2
CREATE USER object_user2 IDENTIFIED BY object_password;

-- nadanie uprawnie uytkownikowi object_user2 do czenia i tworzenia obiektw bazy danych
GRANT connect, resource, create public synonym TO object_user2;

-- przydzielenie uytkownikowi miejsca w przestrzeni tabel users
ALTER USER object_user2 QUOTA 10M ON users;

-- poczenie jako uytkownik object_user
CONNECT object_user2/object_password;

-- tworzenie typw obiektowych
CREATE TYPE t_address AS OBJECT (
  street VARCHAR2(15),
  city VARCHAR2(15),
  state CHAR(3),
  zip VARCHAR2(5)
);
/

CREATE TYPE t_person AS OBJECT (
  id INTEGER,
  first_name VARCHAR2(10),
  last_name VARCHAR2(10),
  dob DATE,
  phone VARCHAR2(12),
  address t_address,
  MEMBER FUNCTION display_details RETURN VARCHAR2
 ) NOT FINAL;
/

CREATE TYPE BODY t_person AS
  MEMBER FUNCTION display_details RETURN VARCHAR2 IS
  BEGIN
    RETURN 'id=' || id || ', name=' || first_name || ' ' || last_name;
  END;
END;
/

CREATE TYPE t_business_person UNDER t_person (
  title VARCHAR2(20),
  company VARCHAR2(20)
);
/


CREATE TYPE t_product AS OBJECT (
  id INTEGER,
  name VARCHAR2(15),
  description VARCHAR2(22),
  price NUMBER(5, 2),
  days_valid INTEGER,

  -- get_sell_by_date() zwraca dat przed ktr
  -- produkt musi zosta sprzedany
  MEMBER FUNCTION get_sell_by_date RETURN DATE
  );
/

CREATE TYPE BODY t_product AS
  -- get_sell_by_date() zwraca dat przed ktr
  -- produkt musi zosta sprzedany
  MEMBER FUNCTION get_sell_by_date RETURN DATE IS
     v_sell_by_date DATE;
  BEGIN
     -- oblicza termin sprzeday poprzez dodanie wartoci atrybutu days_valid
     -- do biecej daty (SYSDATE)
     SELECT days_valid + SYSDATE
     INTO v_sell_by_date
     FROM dual;

    -- zwraca ostateczny termin sprzeday
    RETURN v_sell_by_date;
  END;
END;
/


CREATE TYPE t_vehicle AS OBJECT (
  id INTEGER,
  make VARCHAR2(15),
  model VARCHAR2(15)
) NOT FINAL NOT INSTANTIABLE;
/


CREATE TYPE t_car UNDER t_vehicle (
  convertible CHAR(1)
);
/

CREATE TYPE t_motorcycle UNDER t_vehicle (
  sidecar CHAR(1)
);
/


CREATE OR REPLACE TYPE t_person2 AS OBJECT (
  id         INTEGER,
  first_name VARCHAR2(10),
  last_name  VARCHAR2(10),
  dob        DATE,
  phone      VARCHAR2(12),
  CONSTRUCTOR FUNCTION t_person2(
    p_id         INTEGER,
    p_first_name VARCHAR2,
    p_last_name  VARCHAR2
  ) RETURN SELF AS RESULT,
  CONSTRUCTOR FUNCTION t_person2(
    p_id         INTEGER,
    p_first_name VARCHAR2,
    p_last_name  VARCHAR2,
    p_dob        DATE
  ) RETURN SELF AS RESULT
);
/

CREATE OR REPLACE TYPE BODY t_person2 AS
  CONSTRUCTOR FUNCTION t_person2(
    p_id         INTEGER,
    p_first_name VARCHAR2,
    p_last_name  VARCHAR2
  ) RETURN SELF AS RESULT IS
  BEGIN
    SELF.id := p_id;
    SELF.first_name := p_first_name;
    SELF.last_name := p_last_name;
    SELF.dob := SYSDATE;
    SELF.phone := '555-1212';
    RETURN;
  END;
  CONSTRUCTOR FUNCTION t_person2(
    p_id         INTEGER,
    p_first_name VARCHAR2,
    p_last_name  VARCHAR2,
    p_dob        DATE
  ) RETURN SELF AS RESULT IS
  BEGIN
    SELF.id := p_id;
    SELF.first_name := p_first_name;
    SELF.last_name := p_last_name;
    SELF.dob := p_dob;
    SELF.phone := '555-1213';
    RETURN;
  END;
END;
/

CREATE TYPE t_person3 AS OBJECT (
  id INTEGER,
  first_name VARCHAR2(10),
  last_name VARCHAR2(10),
  MEMBER FUNCTION display_details RETURN VARCHAR2
) NOT FINAL;
/
CREATE TYPE BODY t_person3 AS
  MEMBER FUNCTION display_details RETURN VARCHAR2 IS
  BEGIN
    RETURN 'id=' || id ||
      ', name=' || first_name || ' ' || last_name;
  END;
END;
/

CREATE TYPE t_business_person3 UNDER t_person3 (
  title VARCHAR2(20),
  company VARCHAR2(20),
  OVERRIDING MEMBER FUNCTION display_details RETURN VARCHAR2
);
/
CREATE TYPE BODY t_business_person3 AS
  OVERRIDING MEMBER FUNCTION display_details RETURN VARCHAR2 IS
  BEGIN
    RETURN 'id=' || id ||
      ', name=' || first_name || ' ' || last_name ||
      ', title=' || title || ', company=' || company;
  END;
END;
/




-- tworzenie procedur
CREATE OR REPLACE PROCEDURE subtypes_and_supertypes AS
  -- tworzenie obiektw
  v_business_person t_business_person :=
    t_business_person(
      1, 'Jan', 'Raczek',
      '55/02/01', '800-555-1211',
      t_address('Stanowa 2', 'Fasolowo', 'MAZ', '12345'),
      'Kierownik', 'XYZ SA'
  );
  v_person t_person :=
    t_person(1, 'Jan', 'Raczek', '55/02/01', '800-555-1211',
      t_address('Stanowa 2', 'Fasolowo', 'MAZ', '12345'));
  v_business_person2 t_business_person;
  v_person2 t_person;
BEGIN
  -- przypisuje v_business_person do v_person2
  v_person2 := v_business_person;
  DBMS_OUTPUT.PUT_LINE('v_person2.id = ' || v_person2.id);
  DBMS_OUTPUT.PUT_LINE('v_person2.first_name = ' ||
    v_person2.first_name);
  DBMS_OUTPUT.PUT_LINE('v_person2.last_name = ' ||
    v_person2.last_name);

  -- ponisze wiersze nie zostan skompilowane, poniewa v_person2
  -- jest typu t_person, a t_person nie zna
  -- dodatkowych atrybutw title i company
  -- DBMS_OUTPUT.PUT_LINE('v_person2.title = ' ||
  -- v_person2.title);
  -- DBMS_OUTPUT.PUT_LINE('v_person2.company = ' ||
  -- v_person2.company);
  -- poniszy wiersz nie zostanie skompilowany,
  -- nie mona bezporednio przypisa obiektu
  -- t_person do obiektu t_business_person
  -- v_business_person2 := v_person;
END subtypes_and_supertypes;
/

CREATE PROCEDURE check_types AS
  -- tworzenie obiektw
  v_business_person t_business_person :=
    t_business_person(
      1, 'Jan', 'Raczek',
      '55/02/01', '800-555-1211',
      t_address('Stanowa 2', 'Fasolowo', 'MAZ', '12345'),
      'Manager', 'XYZ Corp'
    );
  v_person t_person :=
    t_person(1, 'Jan', 'Raczek', '55/02/01', '800-555-1211',
      t_address('Stanowa 2', 'Fasolowo', 'MAZ', '12345'));
BEGIN
  -- sprawdzanie typw obiektw
  IF v_business_person IS OF (t_business_person) THEN
    DBMS_OUTPUT.PUT_LINE('v_business_person jest typu ' ||
      't_business_person');
  END IF;
  IF v_person IS OF (t_person) THEN
    DBMS_OUTPUT.PUT_LINE('v_person jest typu t_person');
  END IF;
  IF v_business_person IS OF (t_person) THEN
    DBMS_OUTPUT.PUT_LINE('v_business_person jest typu t_person');
  END IF;
  IF v_business_person IS OF (t_business_person, t_person) THEN
    DBMS_OUTPUT.PUT_LINE('v_business_person jest ' ||
      'typu t_business_person lub t_person');
  END IF;
  IF v_business_person IS OF (ONLY t_business_person) THEN
    DBMS_OUTPUT.PUT_LINE('v_business_person jest tylko ' ||
    'typu t_business_person');
  END IF;
  IF v_business_person IS OF (ONLY t_person) THEN
    DBMS_OUTPUT.PUT_LINE('v_business_person jest tylko ' ||
      'typu t_person');
  ELSE
    DBMS_OUTPUT.PUT_LINE('v_business_person nie jest tylko ' ||
      'typu t_person');
  END IF;
END check_types;
/

CREATE PROCEDURE treat_example AS
  -- tworzenie obiektw
  v_business_person t_business_person :=
    t_business_person(
      1, 'Jan', 'Brzowy',
      '55/02/01', '800-555-1211',
      t_address('Stanowa 2', 'Fasolowo', 'MAZ', '12345'),
      'Kierownik', 'XYZ SA'
  );
  v_person t_person :=
    t_person(1, 'Jan', 'Brzowy', '55/02/01', '800-555-1211',
      t_address('Stanowa 2', 'Fasolowo', 'MAZ', '12345'));
  v_business_person2 t_business_person;
  v_person2 t_person;
  BEGIN
  -- przypisuje v_business_person v_person2
    v_person2 := v_business_person;
    DBMS_OUTPUT.PUT_LINE('v_person2.id = ' || v_person2.id);
    DBMS_OUTPUT.PUT_LINE('v_person2.first_name = ' ||
      v_person2.first_name);
    DBMS_OUTPUT.PUT_LINE('v_person2.last_name = ' ||
      v_person2.last_name);

  -- ponisze wiersze nie zostan skompilowane, poniewa v_person2
  -- jest typu t_person, a t_person nie posiada
  -- dodatkowych atrybutw title i company
  -- DBMS_OUTPUT.PUT_LINE('v_person2.title = ' ||
  -- v_person2.title);
  -- DBMS_OUTPUT.PUT_LINE('v_person2.company = ' ||
  -- v_person2.company);

  -- uycie TREAT przy przypisywaniu v_business_person do v_person2
  DBMS_OUTPUT.PUT_LINE('Uycie TREAT');
  v_person2 := TREAT(v_business_person AS t_person);
  DBMS_OUTPUT.PUT_LINE('v_person2.id = ' || v_person2.id);
  DBMS_OUTPUT.PUT_LINE('v_person2.first_name = ' ||
    v_person2.first_name);
  DBMS_OUTPUT.PUT_LINE('v_person2.last_name = ' ||
    v_person2.last_name);

  -- ponisze wiersze wci nie bd kompilowane, poniewa v_person2
  -- jest typu t_person, a t_person nie posiada
  -- dodatkowych atrybutw title i company
  -- DBMS_OUTPUT.PUT_LINE('v_person2.title = ' ||
  -- v_person2.title);
  -- DBMS_OUTPUT.PUT_LINE('v_person2.company = ' ||
  -- v_person2.company);

  -- ponisze wiersze zostan skompilowane, poniewa uyto TREAT
  DBMS_OUTPUT.PUT_LINE('v_person2.title = ' ||
    TREAT(v_person2 AS t_business_person).title);
  DBMS_OUTPUT.PUT_LINE('v_person2.company = ' ||
    TREAT(v_person2 AS t_business_person).company);

  -- poniszy wiersz nie zostanie skompilowany, poniewa nie mona
  -- bezporednio przypisa obiektu t_person do obiektu t_business_person
  -- v_business_person2 := v_person;
  
  -- poniszy wiersz powoduje wystpienie bdu trakcie wykonywania,
  -- poniewa nie mona przypisa obiektu typu nadrzdnego (v_person)
  -- do obiektu podtypu (v_business_person2)
  -- v_business_person2 := TREAT(v_person AS t_business_person);
END treat_example;
/


-- tworzenie tabel
CREATE TABLE object_business_customers OF t_business_person;

CREATE TABLE object_customers OF t_person;

CREATE TABLE object_customers_not_subs OF t_person
NOT SUBSTITUTABLE AT ALL LEVELS;



CREATE TABLE products (
  product t_product,
  quantity_in_stock INTEGER
)
COLUMN product NOT SUBSTITUTABLE AT ALL LEVELS;


CREATE TABLE vehicles OF t_vehicle;

CREATE TABLE cars OF t_car;

CREATE TABLE motorcycles OF t_motorcycle;

CREATE TABLE object_customers2 OF t_person2;

CREATE TABLE object_business_customers3 OF t_business_person3;

-- wstawianie przykadowych danych do tabeli object_business_customers
INSERT INTO object_business_customers VALUES (
  t_business_person(1, 'Jan', 'Brzowy', '55/02/01', '800-555-1211',
    t_address('Stanowa 2', 'Fasolowo', 'MAZ', '12345'),
     'Kierownik', 'XYZ SA'
  )
);


INSERT INTO object_customers VALUES (
  t_person(1, 'Jan', 'Raczek', '65/05/03', '800-555-1212',
    t_address('Wolnoci 23', 'Gdziekolwiek', 'GDA', '12345')
  )
);

INSERT INTO object_customers VALUES (
  t_business_person(2, 'Stefan', 'Czerny', '55/03/03', '800-555-1212',
    t_address('Rynek 2', 'Gdziekolwiek', 'MAZ', '12345'),
    'Kierownik', 'XYZ SA'
  )
);


-- wstawia przykadowe dane do tabeli cars
INSERT INTO cars VALUES (
  t_car(1, 'Toyota', 'MR2', 'Y')
);

-- wstawia przykadowe dane do tabeli motorcycles
INSERT INTO motorcycles VALUES (
  t_motorcycle(1, 'Harley-Davidson', 'V-Rod', 'N')
);

-- wstawianie przykadowych wierszy do tabeli object_customers2
INSERT INTO object_customers2 VALUES (
  t_person2(1, 'Jerzy', 'Kowalski')
);

INSERT INTO object_customers2 VALUES (
  t_person2(2, 'Grzegorz', 'Nowak', '65/04/03')
);

INSERT INTO object_customers2 VALUES (
  t_person2(3, 'Antoni', 'Leszcz', '75/06/05', '555-1214')
);

INSERT INTO object_business_customers3 VALUES (
  t_business_person3(1, 'Jan', 'Brzowy', 'Kierownik', 'XYZ SA')
);


-- zatwierdza transakcj
COMMIT;
