-- Ten skrypt uruchomi si w Oracle Database 11g lub nowszej.

-- Ten skrypt:
--   1. Tworzy uytkownika lob_user3
--   2. Tworzy tebele i wypenia je danymi
--   3. Tworzy kod PL/SQL 

-- Usunicie uytkownika lob_user3 jeeli istnieje.
DROP USER lob_user3 CASCADE;

-- To polecenie moe zwrci bd jeli uytkownik nie istnieje; nie naley si tym przejmowa.
CREATE USER lob_user3 IDENTIFIED BY lob_password;

-- nadanie uytkownikowi uprawnie do czenia si i tworzenia obiektw bazy danych
GRANT connect, resource TO lob_user3;

-- przydzielenie uytkownikowi miejsca w przestrzeni tabel users
ALTER USER lob_user3 QUOTA 10M ON users;

-- poczenie jako uytkownik lob_user3
CONNECT lob_user3/lob_password;

-- tworzenie tabel 
CREATE TABLE clob_content (
  id INTEGER PRIMARY KEY,
  clob_column CLOB ENCRYPT USING 'AES128'
) LOB(clob_column) STORE AS SECUREFILE (
  CACHE
);

CREATE TABLE credit_cards (
  card_number NUMBER(16, 0) ENCRYPT,
  first_name VARCHAR2(10),
  last_name VARCHAR2(10),
  expiration DATE
);

CREATE TABLE clob_content3 (
  id INTEGER PRIMARY KEY,
  clob_column CLOB
) LOB(clob_column) STORE AS SECUREFILE (
  COMPRESS
  CACHE
);
CREATE TABLE clob_content2 (
  id INTEGER PRIMARY KEY,
  clob_column CLOB
) LOB(clob_column) STORE AS SECUREFILE (
  DEDUPLICATE LOB
  CACHE
);


INSERT INTO clob_content (
  id, clob_column
) VALUES (
  1, TO_CLOB(' Wije si w ciasnym kku')
);

INSERT INTO clob_content (
  id, clob_column
) VALUES (
  2, TO_CLOB(' od dnia do dnia')
);


 
-- commit the transaction
COMMIT;

