-- Ten skrypt SQL*Plus (collection_schema3.sql):
--   1. Tworzy uytkownika collection_user3
--   2. Tworzy baz danych
--   3. Wypenia baz danych przykadowymi danymi
--   4. Tworzy kod PL/SQL

-- usunicie uytkownika collection_user3 jeeli istnieje.
-- To polecenie moe zwrci bd jeli uytkownik nie istnieje; nie naley si tym przejmowa.
DROP USER collection_user3 CASCADE;

-- utworzenie uytkownika collection_user3
CREATE USER collection_user3 IDENTIFIED BY collection_password;

-- nadanie uprawnie uytkownikowi collection_user3 do czenia i tworzenia obiektw bazy danych
GRANT connect, resource, create public synonym TO collection_user3;

-- przydzielenie uytkownikowi miejsca w przestrzeni tabel users
ALTER USER collection_user3 QUOTA 10M ON users;

-- poczenie jako uytkownik collection_user3
CONNECT collection_user3/collection_password;

-- tworzenie obiektw i kolekcji
CREATE TYPE t_varray_address AS VARRAY(3) OF VARCHAR2(50);
/

CREATE TYPE t_address AS OBJECT (
  street VARCHAR2(15),
  city VARCHAR2(15),
  state CHAR(3),
  zip VARCHAR2(5)
);
/

CREATE TYPE t_nested_table_address AS TABLE OF t_address;
/

CREATE TYPE t_address2 AS OBJECT (
  street VARCHAR2(15),
  city VARCHAR2(15),
  state CHAR(3),
  zip VARCHAR2(5),

  -- deklaracja funkcji mapujcej get_string()
  -- zwracajcej napis VARCHAR2
  MAP MEMBER FUNCTION get_string RETURN VARCHAR2
);
/

CREATE TYPE BODY t_address2 AS
  -- definicja funkcji mapujcej get_string()
  MAP MEMBER FUNCTION get_string RETURN VARCHAR2 IS
  BEGIN
    -- zwraca skonkatenowany napis, zawierajcy wartoci
    -- atrybutw zip, state, city i street
    RETURN zip || ' ' || state || ' ' || city || ' ' || street;
  END get_string;
END;
/

CREATE TYPE t_nested_table_address2 AS TABLE OF t_address2;
/

CREATE TYPE t_varray_address2 AS VARRAY(3) OF t_address;
/

CREATE TYPE T_TABLE AS TABLE OF VARCHAR(10);
/

-- associative array example
CREATE OR REPLACE PROCEDURE customers_associative_array AS
  -- definiuje typ tablicy asocjacyjnej o nazwie t_assoc_array;
  -- warto skadowana w kadym elemencie tablicy jest typu NUMBER
  -- a klucz indeksu do pobrania kadego elementu jest typu VARCHAR2
  TYPE t_assoc_array IS TABLE OF NUMBER INDEX BY VARCHAR2(15);

  -- deklaracja obiektu v_customer_array o typie t_assoc_array;
  -- v_customer_array bdzie uyty do skadowania wieku klientw
  v_customer_array t_assoc_array;
BEGIN
  -- przypisuje wartoci v_customer_array; Klucz VARCHAR2
  -- jest nazw klienta, a warto NUMBER jest wiekiem klienta
  v_customer_array('Jan') := 32;
  v_customer_array('Stefan') := 28;
  v_customer_array('Fryderyk') := 43;
  v_customer_array('Sylwia') := 27;

  -- wyweitla wartoci skadowane w v_customer_array
  DBMS_OUTPUT.PUT_LINE(
    'v_customer_array[''Jan''] = ' || v_customer_array('Jan')
  );
  DBMS_OUTPUT.PUT_LINE(
    'v_customer_array[''Stefan''] = ' || v_customer_array('Stefan')
  );
  DBMS_OUTPUT.PUT_LINE(
    'v_customer_array[''Fryderyk''] = ' || v_customer_array('Fryderyk')
  );
  DBMS_OUTPUT.PUT_LINE(
    'v_customer_array[''Sylwia''] = ' || v_customer_array('Sylwia')
  );
END customers_associative_array;
/

-- varray in temporary table example
CREATE GLOBAL TEMPORARY TABLE cust_with_varray_temp_table (
  id         INTEGER PRIMARY KEY,
  first_name VARCHAR2(10),
  last_name  VARCHAR2(10),
  addresses  t_varray_address
);

-- different tablespace for a nested table's storage table example
-- (assumes you have a tablespace named users, so you'll need to edit
-- the TABLESPACE clause and uncomment the example)
/*
CREATE TABLE cust_with_nested_table (
  id         INTEGER PRIMARY KEY,
  first_name VARCHAR2(10),
  last_name  VARCHAR2(10),
  addresses  t_nested_table_address
)
NESTED TABLE
  addresses
STORE AS
  nested_addresses2 TABLESPACE users;
*/

-- equal/not equal example
CREATE OR REPLACE PROCEDURE equal_example AS
  -- deklaracja typu o nazwie t_nested_table
  TYPE t_nested_table IS TABLE OF VARCHAR2(10);

  -- tworzenie obiektw typu t_nested_table o nazwach 
  -- v_customer_nested_table1, v_customer_nested_table2 i
  -- v_customer_nested_table1. Bd w nich skadowane 
  -- nazwy klientw
  v_customer_nested_table1 t_nested_table :=
    t_nested_table('Fryderyk', 'Jerzy', 'Zuzanna');
  v_customer_nested_table2 t_nested_table :=
    t_nested_table('Fryderyk', 'Jerzy', 'Zuzanna');
  v_customer_nested_table3 t_nested_table :=
    t_nested_table('Jzef', 'Jerzy', 'Zuzanna');
  v_result BOOLEAN;
BEGIN
  -- uycie operatora = do porwnania v_customer_nested_table1 z 
  -- v_customer_nested_table2 (zawieraj te same nazwy, 
  -- wic v_result ma warto true)
  v_result := v_customer_nested_table1 = v_customer_nested_table2;
  IF v_result THEN
    DBMS_OUTPUT.PUT_LINE(
      'v_customer_nested_table1 rwne v_customer_nested_table2'
    );
  END IF;

  -- uycie operatora <> do porwnania v_customer_nested_table1 z 
  -- v_customer_nested_table3 (nie s rwne, poniewa pierwsze nazwy,
  -- 'Fryderyk' i 'Jzef' s rne, wic v_result ma warto false)
  v_result := v_customer_nested_table1 <> v_customer_nested_table3;
  IF v_result THEN
    DBMS_OUTPUT.PUT_LINE(
      'v_customer_nested_table1 nie rwne v_customer_nested_table3'
    );
  END IF;
END equal_example;
/

-- IN/NOT IN example
CREATE OR REPLACE PROCEDURE in_example AS
  TYPE t_nested_table IS TABLE OF VARCHAR2(10);
  v_customer_nested_table1 t_nested_table :=
    t_nested_table('Fryderyk', 'Jerzy', 'Zuzanna');
  v_customer_nested_table2 t_nested_table :=
    t_nested_table('Jzef', 'Jerzy', 'Zuzanna');
  v_customer_nested_table3 t_nested_table :=
    t_nested_table('Fryderyk', 'Jerzy', 'Zuzanna');
  v_result BOOLEAN;
BEGIN
  -- Uycie operatora IN do sprawdzenia, czy elementy tabeli
  -- v_customer_nested_table3 wystpuj w tabeli v_customer_nested_table1
  -- (wystpuj, wic v_result ma warto true)
  v_result := v_customer_nested_table3 IN (v_customer_nested_table1);
  IF v_result THEN
    DBMS_OUTPUT.PUT_LINE(
      'v_customer_nested_table3 IN v_customer_nested_table1'
    );
  END IF;

  -- Uycie operatora NOT IN do sprawdzenia, czy elementy tabeli
  -- v_customer_nested_table3 wystpuj w tabeli v_customer_nested_table2
  -- (nie wystpuj, wic v_result ma warto true)
  v_result := v_customer_nested_table3 NOT IN (v_customer_nested_table2);
  IF v_result THEN
    DBMS_OUTPUT.PUT_LINE(
      'v_customer_nested_table3 NOT IN v_customer_nested_table2'
    );
  END IF;
END in_example;
/

-- SUBMULTISET example
CREATE OR REPLACE PROCEDURE submultiset_example AS
  TYPE t_nested_table IS TABLE OF VARCHAR2(10);
  v_customer_nested_table1 t_nested_table :=
    t_nested_table('Fryderyk', 'Jerzy', 'Zuzanna');
  v_customer_nested_table2 t_nested_table :=
    t_nested_table('Jerzy', 'Fryderyk', 'Zuzanna', 'Jan', 'Stefan');
  v_result BOOLEAN;
BEGIN
  -- uycie operatora SUBMULTISET do sprawdzenia, czy elementy tabeli 
  -- v_customer_nested_table_1 s podzbiorem tabeli v_customer_nested_table2 
  -- (Tak jest, wic v_result ma warto true).
  v_result :=
    v_customer_nested_table1 SUBMULTISET OF v_customer_nested_table2;
  IF v_result THEN
    DBMS_OUTPUT.PUT_LINE(
      'v_customer_nested_table1 jest podzbiorem v_customer_nested_table2'
    );
  END IF;
END submultiset_example;
/

-- MULTISET example
CREATE OR REPLACE PROCEDURE multiset_example AS
  TYPE t_nested_table IS TABLE OF VARCHAR2(10);
  v_customer_nested_table1 t_nested_table :=
    t_nested_table('Fryderyk', 'Jerzy', 'Zuzanna');
  v_customer_nested_table2 t_nested_table :=
    t_nested_table('Jerzy', 'Stefan', 'Robert');
  v_customer_nested_table3 t_nested_table;
  v_count INTEGER;
  BEGIN
  -- uycie MULTISET UNION (zwraca tabel zagniedon, ktrej elementy stanowi sum
  -- elementw przesanych tabel zagniedonych
  v_customer_nested_table3 :=
    v_customer_nested_table1 MULTISET UNION
      v_customer_nested_table2;
  DBMS_OUTPUT.PUT('UNION: ');
  FOR v_count IN 1..v_customer_nested_table3.COUNT LOOP
    DBMS_OUTPUT.PUT(v_customer_nested_table3(v_count) || ' ');
  END LOOP;
  DBMS_OUTPUT.PUT_LINE(' ');

  -- uycie MULTISET UNION DISTINCT (DISTINCT okrela, e w zwracanej tabeli zagniedonej
  -- znajd si jedynie niepowtarzajce si elementy z dwch tabel)
  v_customer_nested_table3 :=
    v_customer_nested_table1 MULTISET UNION DISTINCT
      v_customer_nested_table2;
  DBMS_OUTPUT.PUT('UNION DISTINCT: ');
  FOR v_count IN 1..v_customer_nested_table3.COUNT LOOP
    DBMS_OUTPUT.PUT(v_customer_nested_table3(v_count) || ' ');
  END LOOP;
  DBMS_OUTPUT.PUT_LINE(' ');

  -- uycie MULTISET INTERSECT (zwraca tabel zagniedon, ktrej elementami
  -- s elementy wsplne w przesanych tabelach zagniedonych 
  v_customer_nested_table3 :=
    v_customer_nested_table1 MULTISET INTERSECT
      v_customer_nested_table2;
  DBMS_OUTPUT.PUT('INTERSECT: ');
  FOR v_count IN 1..v_customer_nested_table3.COUNT LOOP
    DBMS_OUTPUT.PUT(v_customer_nested_table3(v_count) || ' ');
  END LOOP;
  DBMS_OUTPUT.PUT_LINE(' ');

  -- uycie MULTISET EXCEPT (zwraca tabel zagniedon, ktrej elementy znajduj si 
  -- w pierwszej tabeli i nie znajduj si w drugiej tabeli
  v_customer_nested_table3 :=
    v_customer_nested_table1 MULTISET EXCEPT
      v_customer_nested_table2;
  DBMS_OUTPUT.PUT_LINE('EXCEPT: ');
  FOR v_count IN 1..v_customer_nested_table3.COUNT LOOP
    DBMS_OUTPUT.PUT(v_customer_nested_table3(v_count) || ' ');
  END LOOP;
END multiset_example;
/


-- CARDINALITY example
CREATE PROCEDURE cardinality_example AS
  TYPE t_nested_table IS TABLE OF VARCHAR2(10);
  v_customer_nested_table1 t_nested_table :=
    t_nested_table('Fryderyk', 'Jerzy', 'Zuzanna');
  v_cardinality INTEGER;
BEGIN
  -- wywoanie CARDINALITY() w celu pobrania liczby elementw w
  -- v_customer_nested_table1
  v_cardinality := CARDINALITY(v_customer_nested_table1);
  DBMS_OUTPUT.PUT_LINE('v_cardinality = ' || v_cardinality);
END cardinality_example;
/

-- MEMBER OF example
CREATE OR REPLACE PROCEDURE member_of_example AS
  TYPE t_nested_table IS TABLE OF VARCHAR2(10);
  v_customer_nested_table1 t_nested_table :=
    t_nested_table('Fryderyk', 'Jerzy', 'Zuzanna');
  v_result BOOLEAN;
BEGIN
  -- uycie MEMBER OF do sprawdzenia, czy w v_customer_nested_table1
  -- znajduje si element 'Jerzy' (tak jest, wic v_result ma warto true).
  v_result := 'Jerzy' MEMBER OF v_customer_nested_table1;
  IF v_result THEN
    DBMS_OUTPUT.PUT_LINE('"Jerzy" naley do zbioru');
  END IF;
END member_of_example;
/



-- SET example
CREATE OR REPLACE PROCEDURE set_example AS
  TYPE t_nested_table IS TABLE OF VARCHAR2(10);
  v_customer_nested_table1 t_nested_table :=
    t_nested_table('Fryderyk', 'Jerzy', 'Zuzanna', 'Jerzy');
  v_customer_nested_table2 t_nested_table;
  v_count INTEGER;
BEGIN
  -- wywoanie SET() w celu przeksztacenia tabeli zagniedonej
  -- w zestaw, usunicia z niego duplikatw i pobrania
  -- zestawu jako tabeli zagniedonej
  v_customer_nested_table2 := SET(v_customer_nested_table1);
  DBMS_OUTPUT.PUT('v_customer_nested_table2: ');
  FOR v_count IN 1..v_customer_nested_table2.COUNT LOOP
    DBMS_OUTPUT.PUT(v_customer_nested_table2(v_count) || ' ');
  END LOOP;
  DBMS_OUTPUT.PUT_LINE(' ');
END set_example;
/


-- IS A SET example
CREATE OR REPLACE PROCEDURE is_a_set_example AS
  TYPE t_nested_table IS TABLE OF VARCHAR2(10);
  v_customer_nested_table1 t_nested_table :=
    t_nested_table('Fryderyk', 'Jerzy', 'Zuzanna', 'Jerzy');
  v_result BOOLEAN;
BEGIN
  -- uycie operatora IS A SET do sprawdzenia, czy elementy w
  -- v_customer_nested_table1 nie powtarzaj si (powtarzaj, wic
  -- v_result ma warto false)
  v_result := v_customer_nested_table1 IS A SET;
  IF v_result THEN
    DBMS_OUTPUT.PUT_LINE('Wszystkie elementy s unikatowe');
  ELSE
    DBMS_OUTPUT.PUT_LINE('Wrd elementw znajduj si duplikaty');
  END IF;
END is_a_set_example;
/


-- IS EMPTY example
CREATE OR REPLACE PROCEDURE is_empty_example AS
  TYPE t_nested_table IS TABLE OF VARCHAR2(10);
  v_customer_nested_table1 t_nested_table :=
    t_nested_table('Fryderyk', 'Jerzy', 'Zuzanna');
  v_result BOOLEAN;
BEGIN
  -- uycie operatora IS EMPTY do sprawdzenia, czy tabela
  -- v_customer_nested_table1 jest pusta (nie jest, wic
  -- v_result ma warto false)
  v_result := v_customer_nested_table1 IS EMPTY;
  IF v_result THEN
    DBMS_OUTPUT.PUT_LINE('Tabela zagniedona jest pusta');
  ELSE
    DBMS_OUTPUT.PUT_LINE('Tabela zagniedona zawiera elementy');
  END IF;
END is_empty_example;
/

CREATE TABLE customers_with_varray (
  id INTEGER PRIMARY KEY,
  first_name VARCHAR2(10),
  last_name VARCHAR2(10),
  addresses t_varray_address
);

INSERT INTO customers_with_varray VALUES (
  1, 'Stefan', 'Brzowy',
  t_varray_address(
    'Stanowa 2, Fasolowo, MAZ, 12345',
    'Grska 4, Rzeszotary, GDA, 54321'
  )
);

INSERT INTO customers_with_varray VALUES (
  2, 'Jan', 'Kowalski',
  t_varray_address(
    'Wysoka 1, Zae, MA, 12347',
    'Nowa 4, Byczyna, MAZ, 54323',
    'Handlowa 7, Zarzecze, POZ, 54323'
  )
);



-- commit the transaction
COMMIT;
