CREATE OR REPLACE FUNCTION update_price RETURN INTEGER IS

  -- Zmienne lokalne używane przy przetwarzaniu.
  lv_price_id    NUMBER;
  lv_start_date  DATE;
  lv_end_date    DATE;
  
  -- Deklaracja typu kolekcji.
  TYPE flags IS TABLE OF VARCHAR2(1);
  
  -- Deklaracja tablicy.
  flag FLAGS := flags('Y','N');

  -- Deklaracja kursora ITEM.
  CURSOR item IS
    SELECT   i.item_id
    ,        i.item_release_date
    FROM     item i;

  -- Deklaracja kursora COMMON_LOOKUP.
  CURSOR common_lookup IS
    SELECT common_lookup_id AS price_type
    ,      common_lookup_code AS amount
    FROM   common_lookup
    WHERE  common_lookup_table = 'PRICE'
    AND    common_lookup_column = 'AMOUNT'
    AND    common_lookup_type LIKE '%-DAY RENTAL';

BEGIN

  -- Ustawianie punktu zapisu.
  SAVEPOINT all_or_none;

  -- Przejście w pętli po kolekcji z wartościami Y i N.
  FOR i IN 1..flag.COUNT LOOP
  
    -- Przejście w pętli po tabeli COMMON_LOOKUP.
    FOR j IN common_lookup LOOP
    
      -- Przejście w pętli po tabeli ITEM.
      FOR k IN item LOOP

        -- Zgodne z wersją Oracle 10g.
        SELECT   price_s1.NEXTVAL
        INTO     lv_price_id
        FROM     dual;

        -- Ustawianie dat początku i końca obowiązywania ceny.
        IF TRUNC(SYSDATE) - 30 = k.item_release_date AND flag(i) = 'N' THEN
          lv_start_date := TRUNC(k.item_release_date);
          lv_end_date := TRUNC(k.item_release_date) + 30;
        ELSIF TRUNC(SYSDATE) - 30 > k.item_release_date AND flag(i) = 'Y' THEN
          lv_start_date := TRUNC(k.item_release_date) + 31;
        END IF;
        
        -- Wstawianie danych do tabeli price.
        INSERT INTO price
        ( price_id
        , item_id
        , price_type
        , active_flag
        , start_date
        , end_date
        , amount
        , created_by
        , creation_date
        , last_updated_by
        , last_update_date )
        VALUES
        ( lv_price_id
        , k.item_id
        , j.price_type
        , flag(i)
        , lv_start_date
        , lv_end_date
        , j.amount
        , 1
        , SYSDATE
        , 1
        , SYSDATE );

    
      END LOOP;
    END LOOP;
  END LOOP;
  
  -- Zatwierdzanie rekordów.
  COMMIT;
  
  -- Zwracanie liczby całkowitej.
  RETURN 0;
  
EXCEPTION

  -- Wartość zwracana dla wyjątków.
  WHEN OTHERS THEN
    ROLLBACK TO all_or_none;
    RETURN 1;
  
END update_price;
/