/* ================================================================
||   Program: create_nds8.sql
||   Data:       2013-07-25
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   13
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   Ten skrypt ilustruje używanie języka NDS. 
|| ================================================================*/

-- Po debugowaniu umieść w komentarzu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  -- Deklaracja struktury rekordowej i tabeli zagnieżdżonej z tymi strukturami.
  TYPE title_record IS RECORD
  ( item_title     VARCHAR2(60)
  , item_subtitle  VARCHAR2(60));
  TYPE title_table IS TABLE OF title_record;
  -- Deklaracje zmiennych dynamicznych.  
  title_cursor  SYS_REFCURSOR;
  title_rows    TITLE_TABLE;
  -- Deklaracje zmiennych pakietu DBMS_SQL.
  c             INTEGER := dbms_sql.open_cursor;
  fdbk          INTEGER;
  -- Deklaracje zmiennych lokalnych.
  counter       NUMBER := 1;
  column_names  DBMS_SQL.VARCHAR2_TABLE;
  item_ids      DBMS_SQL.NUMBER_TABLE;
  stmt          VARCHAR2(2000);
  substmt       VARCHAR2(2000) := '';
BEGIN
  -- Wyszukiwanie wiersza spełniającego kryteria.
  FOR i IN (SELECT 'item_ids' AS column_names
            ,       item_id
            FROM    item
            WHERE   REGEXP_LIKE(item_title,'^Harry Potter')) LOOP
    column_names(counter) := counter;
    item_ids(counter) := i.item_id;
    counter := counter + 1;
  END LOOP;
 
  dbms_sql.close_cursor(c);
  -- Dynamiczne tworzenie instrukcji podrzędnej.
  IF item_ids.COUNT = 1 THEN
    substmt := 'WHERE item_id IN (:item_ids)';
  ELSE
    substmt := 'WHERE item_id IN (';
    FOR i IN 1..item_ids.COUNT LOOP
      IF i = 1 THEN
        substmt := substmt ||':'||i;
      ELSE
        substmt := substmt ||',:'||i;
      END IF;
    END LOOP;
    substmt := substmt || ')';
  END IF;

  -- Tworzenie instrukcji.
  stmt := 'SELECT  item_title, item_subtitle '
       || 'FROM    item '
       ||  substmt;
       
  -- Parsowanie instrukcji za pomocą pakietu DBMS_SQL
  dbms_sql.parse(c,stmt,dbms_sql.native);

  -- Wiązanie zmiennych z wartościami.
  FOR i IN 1..item_ids.COUNT LOOP
    dbms_sql.bind_variable(c,column_names(i),item_ids(i));
  END LOOP;

  -- Wykonywanie instrukcji za pomocą pakietu DBMS_SQL.  
  fdbk := dbms_sql.execute(c);
  
  -- Przekształcanie kursora na postać dla języka NDS.
  title_cursor := dbms_sql.to_refcursor(c);
  
  -- Otwieranie i wczytywanie kursora dynamicznego oraz zamykanie go.
  FETCH title_cursor BULK COLLECT INTO title_rows;

  FOR i IN 1..title_rows.COUNT LOOP
    dbms_output.put_line(
      '['||title_rows(i).item_title||']['||title_rows(i).item_subtitle||']');
  END LOOP;

  -- Zamykanie systemowego kursora referencyjnego.
  CLOSE title_cursor;
END;
/

