/* ================================================================
||   Program: get_canonical_bfilename.sql
||   Data:       2013-07-25
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   10
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   UWAGI:
||   - Ten skrypt wymaga, aby w schemacie SYSTEM  znajdowała się 
||     działająca funkcja GET_DIRECTORY_PATH.
||   - Skrypt get_directory_path.sql tworzy potrzebną funkcję
||     GET_DIRECTORY_PATH i synonimy oraz przyznaje uprawnienia.
||
||   Ten skrypt obejmuje funkcję składowaną, która zwraca ścieżkę kanononiczną 
||   (czyli kompletną ścieżkę wraz z nazwą pliku na podstawie kolummny
||   typu BFILENAME).
|| ================================================================*/

-- Po zakończeniu debugowania umieść w komentarzu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

CREATE OR REPLACE FUNCTION get_canonical_bfilename
( table_name        IN     VARCHAR2
, bfile_column_name IN     VARCHAR2
, primary_key       IN     VARCHAR2
, primary_key_value IN     VARCHAR2
, operating_system  IN     VARCHAR2 := 'WINDOWS')
RETURN VARCHAR2 IS

  -- Deklaracja domyślnego ogranicznika.
  delimiter         VARCHAR2(1) := '\';
  
  -- Definicja zmiennej na instrukcję.
  stmt              VARCHAR2(200);

  -- Definicja lokalizatora.
  locator           BFILE;

  -- Definicje zmiennych na alias, katalog i nazwę pliku.
  dir_alias         VARCHAR2(255);
  directory         VARCHAR2(255);
  file_name         VARCHAR2(255);

  -- Definicja lokalnego wyjątku związanego z przekroczeniem limitu wielkości.
  directory_num EXCEPTION;
  PRAGMA EXCEPTION_INIT(directory_num,-22285);  

BEGIN

  -- Przypisanie dynamicznego łańcucha znaków do instrukcji.
  stmt := 'BEGIN '
       || ' SELECT '||bfile_column_name||' '
       || ' INTO :column_value '
       || ' FROM  '||table_name||' '
       || ' WHERE '||primary_key||'='||''''||primary_key_value||''''||';'
       || 'END;';

  -- Uruchamianie dynamicznej instrukcji.       
  EXECUTE IMMEDIATE stmt USING OUT locator;
 
  -- Sprawdzanie, czy lokalizator jest dostępny.
  IF locator IS NOT NULL THEN     
    dbms_lob.filegetname(locator,dir_alias,file_name);
  END IF;

  -- Sprawdzanie systemu operacyjnego i w razie potrzeby zamiana ogranicznika.
  IF operating_system <> 'WINDOWS' THEN
    delimiter := '/';
  END IF;
  
  -- Tworzenie kanonicznej nazwy pliku.
  file_name := get_directory_path(dir_alias) || delimiter || file_name;

  -- Zwracanie nazwy pliku.
  RETURN file_name;

EXCEPTION
  WHEN directory_num THEN
  RETURN NULL;

END get_canonical_bfilename;
/
