/* ================================================================
||   Program: create_nds6.sql
||   Data:       2013-07-25
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   13
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   Ten skrypt ilustruje używanie języka NDS. 
|| ================================================================*/

-- Po debugowaniu umieść w komentarzu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  -- Definicja struktury rekordowej.
  target  CLOB;
  source  VARCHAR2(2000) := 'Klasyk w reżyserii Mela Brooksa!';
  movie   VARCHAR2(60) := 'Young Frankenstein';
  stmt    VARCHAR2(2000);
BEGIN
  -- Tworzenie instrukcji.
  stmt := 'BEGIN '
       || 'UPDATE  item '
       || 'SET     item_desc = empty_clob() '
       || 'WHERE   item_id = '
       || '          (SELECT item_id '
       || '           FROM   item '
       || '           WHERE  item_title = :input) '
       || 'RETURNING item_desc INTO :descriptor;'
       || 'END;';

  EXECUTE IMMEDIATE stmt USING movie, IN OUT target;
  dbms_lob.writeappend(target,LENGTH(source),source);
  COMMIT;
END;
/

SELECT item_desc FROM item WHERE item_title = 'Young Frankenstein';

