/* ================================================================
||   Program: java_library.sql
||   Data:       2013-07-25
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   8
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   Ten skrypt ilustruję bibliotekę Javy i nakładkę na nią w 
||   języku PL/SQL.
|| ================================================================*/

SET SERVEROUTPUT ON SIZE UNLIMITED


CREATE OR REPLACE AND COMPILE JAVA SOURCE NAMED "TwoSignersJava" AS

  // Wymagane biblioteki klas.
  import java.sql.*;
  import oracle.jdbc.driver.*;

  // Definicja klasy.
  public class TwoSignersJava {

	// Nawiązywanie połączenia i sprawdzanie, czy wstawiane dane nie są duplikatem.
    public static int contactTrigger(Integer memberID)
      throws SQLException {
      Boolean duplicateFound = false;  // Domyślna wartość kontrolna.

      // Nawiązywanie połączenia dla Javy 5 i bazy Oracle 11g.
      Connection conn =
        DriverManager.getConnection("jdbc:default:connection:");

      // Tworzenie przygotowanej instrukcji ze zmienną powiązaną.
      PreparedStatement ps =
         conn.prepareStatement("SELECT   null " +
                               "FROM     contact c JOIN member m " +
                               "ON       c.member_id = m.member_id " +
                               "WHERE    c.member_id = ? " +
                               "HAVING   COUNT(*) > 1");

      // Wiązanie zmiennej lokalnej z odpowiednim miejscem w instrukcji.
      ps.setInt(1, memberID);

      // Wykonywanie zapytania i sprawdzanie, czy nie istnieje powtarzająca się wartość.
      ResultSet rs = ps.executeQuery();
      if (rs.next())
        duplicateFound = true;         // Zmiana wartości kontrolnej.

      // Zwalnianie zasobów.
      rs.close();
      ps.close();
      conn.close();

      /* Zwracanie 1 (true), jeśli istnieją dwa elementy, i 0 w przeciwnym razie. */
      if (duplicateFound) return 1;
      else                return 0; }}
/

CREATE OR REPLACE FUNCTION two_signers
( pv_member_id  NUMBER) RETURN NUMBER IS
LANGUAGE JAVA
NAME 'TwoSignersJava.contactTrigger(java.lang.Integer) return int';
/

SELECT  CASE
          WHEN two_signers(member_id) = 0 THEN 'Tylko jeden element.'
          ELSE 'Są już dwa elementy.'
        END AS "Możliwe przypisanie"
FROM    contact c JOIN member m USING (member_id)
WHERE   c.last_name = 'Sweeney'
OFFSET 1 ROWS FETCH FIRST 1 ROWS ONLY;
