/* ================================================================
||   Program: symmetric_composites.sql
||   Data:       2013-07-25
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   6
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   Ten skrypt ilustruje kolekcje (tabele zagnieżdżone i tablice varray).
|| ================================================================*/

DROP TYPE prominent_table;
DROP TYPE people_table;
DROP TYPE prominent_object;
DROP TYPE prominent_table;

CREATE OR REPLACE
  TYPE prominent_object IS OBJECT
  ( name     VARCHAR2(20)
  , age      VARCHAR2(10));
/

CREATE OR REPLACE
  TYPE prominent_table IS TABLE OF prominent_object;
/

CREATE OR REPLACE
  TYPE people_object IS OBJECT
  ( race      VARCHAR2(10)
  , exemplar  PROMINENT_OBJECT);
/

CREATE OR REPLACE
  TYPE people_table IS TABLE OF people_object;
/

COLUMN EXEMPLAR FORMAT A40
SELECT *
FROM   TABLE(
         SELECT CAST(COLLECT(
                  people_object(
                     'Ludzie'
                    , prominent_object('Aragorn','3rd Age')
                    )
                  ) AS people_table
                )
         FROM dual);


SELECT o.race, n.name, n.age
FROM   TABLE(
         SELECT CAST(COLLECT(
                  people_object(
                     'Ludzie'
                    , prominent_object('Aragorn','3rd Age')
                    )
                  ) AS people_table
                )
         FROM  dual) o CROSS JOIN
          TABLE(
            SELECT CAST(COLLECT(exemplar) AS prominent_table)
            FROM dual) n;

SELECT  o.race, n.name, n.age
FROM    TABLE(
          people_table(
              people_object(
                 'Ludzie'
                , prominent_object('Aragorn','3rd Age'))
            , people_object(
                 'Elfy'
                , prominent_object('Legolas','3rd Age'))
             )) o CROSS JOIN
        TABLE(
          SELECT CAST(COLLECT(exemplar) AS prominent_table)
          FROM dual) n; 



DECLARE
  /* Deklaracja tabeli zagnieżdżonej. */
  lv_tolkien_table  PEOPLE_TABLE :=
                      people_table(
                        people_object(
                             'Ludzie'
                            , prominent_object('Aragorn','3rd Age'))
                          , people_object(
                             'Elfy'
                          , prominent_object('Legolas','3rd Age')));
BEGIN
  /* Dodawanie nowego rekordu do kolekcji. */
  lv_tolkien_table.EXTEND;
  lv_tolkien_table(lv_tolkien_table.COUNT) :=
     people_object('Krasnaludy'
                  , prominent_object('Gimili','3rd Age'));

  /* Wczytywanie i wyświetlanie wartości z kolekcji. */
  FOR i IN lv_tolkien_table.FIRST..lv_tolkien_table.LAST LOOP
    dbms_output.put_line(
      lv_tolkien_table(i).race||': '||lv_tolkien_table(i).exemplar.name);
  END LOOP;
END;
/


DECLARE
  /* Deklaracja rekordu języka PL/SQL. */
  TYPE tolkien_record IS RECORD
  ( race      VARCHAR2(10)
  , name      VARCHAR2(20)
  , age       VARCHAR2(10));

  /* Deklaracja tabeli zagnieżdżonej z rekordami. */
  TYPE tolkien_plsql_table IS TABLE OF TOLKIEN_RECORD;

  /* Deklaracje zmiennych na rekord i tabelę zagnieżdżoną. */
  lv_tolkien_record       TOLKIEN_RECORD;
  lv_tolkien_plsql_table  TOLKIEN_PLSQL_TABLE;

  /* Deklaracja tabeli zagnieżdżonej. */
  lv_tolkien_table  PEOPLE_TABLE :=
                      people_table(
                        people_object(
                           'Ludzie'
                          , prominent_object('Aragorn','3rd Age'))
                      , people_object(
                           'Elfy'
                          , prominent_object('Legolas','3rd Age')));
BEGIN
  /* Jednowierszowe podzapytanie niejawne. */
  SELECT   o.race, n.name, n.age
  INTO     lv_tolkien_record
  FROM     TABLE(lv_tolkien_table) o CROSS JOIN
             TABLE(
               SELECT CAST(COLLECT(exemplar) AS prominent_table)
               FROM   dual) n
  WHERE    ROWNUM < 2;

  dbms_output.put_line(
    '['||lv_tolkien_record.race||'] '||
    '['||lv_tolkien_record.name||'] '||
    '['||lv_tolkien_record.age ||']');
END;
/

DECLARE
  /* Deklaracja rekordu języka PL/SQL. */
  TYPE tolkien_record IS RECORD
  ( race      VARCHAR2(10)
  , name      VARCHAR2(20)
  , age       VARCHAR2(10));

  /* Deklaracja tabeli zagnieżdżonej z rekordami. */
  TYPE tolkien_plsql_table IS TABLE OF TOLKIEN_RECORD;

  /* Deklaracje zmiennych na rekord i tabelę zagnieżdżoną. */
  lv_tolkien_record       TOLKIEN_RECORD;
  lv_tolkien_plsql_table  TOLKIEN_PLSQL_TABLE;

  /* Deklaracja tabeli zagnieżdżonej. */
  lv_tolkien_table  PEOPLE_TABLE :=
                      people_table(
                        people_object(
                           'Ludzie'
                          , prominent_object('Aragorn','3rd Age'))
                      , people_object(
                           'Elfy'
                          , prominent_object('Legolas','3rd Age')));
BEGIN
  /* Jednowierszowe podzapytanie niejawne. */
  SELECT   o.race, n.name, n.age
  INTO     lv_tolkien_record
  FROM     TABLE(lv_tolkien_table) o CROSS JOIN
             TABLE(
               SELECT CAST(COLLECT(exemplar) AS prominent_table)
               FROM   dual) n
  FETCH    FIRST 1 ROWS ONLY;

  dbms_output.put_line(
    '['||lv_tolkien_record.race||'] '||
    '['||lv_tolkien_record.name||'] '||
    '['||lv_tolkien_record.age ||']');
END;
/

DECLARE
  /* Deklaracja rekordu języka PL/SQL. */
  TYPE tolkien_record IS RECORD
  ( race      VARCHAR2(10)
  , name      VARCHAR2(20)
  , age       VARCHAR2(10));

  /* Deklaracja tabeli zagnieżdżonej z rekordami. */
  TYPE tolkien_plsql_table IS TABLE OF TOLKIEN_RECORD;

  /* Deklaracje zmiennych na rekord i tabelę zagnieżdżoną. */
  lv_tolkien_record       TOLKIEN_RECORD;
  lv_tolkien_plsql_table  TOLKIEN_PLSQL_TABLE;

  /* Deklaracja tabeli zagnieżdżonej. */
  lv_tolkien_table  PEOPLE_TABLE :=
                      people_table(
                        people_object(
                           'Ludzie'
                          , prominent_object('Aragorn','3rd Age'))
                      , people_object(
                           'Elfy'
                          , prominent_object('Legolas','3rd Age')));
BEGIN
  /* Jednowierszowe podzapytanie niejawne. */
  SELECT   o.race, n.name, n.age
  BULK COLLECT INTO lv_tolkien_plsql_table
  FROM     TABLE(lv_tolkien_table) o CROSS JOIN
             TABLE(
               SELECT CAST(COLLECT(exemplar) AS prominent_table)
               FROM   dual) n
  FETCH    FIRST 1 ROWS ONLY;

  /* Przejście w pętli po zbiorze wyników i ich wyświetlanie. */
  FOR i IN 1..lv_tolkien_plsql_table.COUNT LOOP
    dbms_output.put_line(
      '['||lv_tolkien_plsql_table(i).race||'] '||
      '['||lv_tolkien_plsql_table(i).name||'] '||
      '['||lv_tolkien_plsql_table(i).age ||']');
  END LOOP;
END;
/

DECLARE
  /* Deklaracja rekordu języka PL/SQL. */
  TYPE tolkien_record IS RECORD
  ( race      VARCHAR2(10)
  , name      VARCHAR2(20)
  , age       VARCHAR2(10));

  /* Deklaracja tabeli zagnieżdżonej z rekordami. */
  TYPE tolkien_plsql_table IS TABLE OF TOLKIEN_RECORD;

  /* Deklaracje zmiennych na rekord i tabelę zagnieżdżoną. */
  lv_tolkien_record       TOLKIEN_RECORD;
  lv_tolkien_plsql_table  TOLKIEN_PLSQL_TABLE;

  /* Deklaracja tabeli zagnieżdżonej. */
  lv_tolkien_table  PEOPLE_TABLE :=
                      people_table(
                        people_object(
                           'Ludzie'
                          , prominent_object('Aragorn','3rd Age'))
                      , people_object(
                           'Elfy'
                          , prominent_object('Legolas','3rd Age')));
BEGIN
  /* Jednowierszowe podzapytanie niejawne. */
  SELECT   o.race, n.name, n.age
  BULK COLLECT INTO lv_tolkien_plsql_table
  FROM     TABLE(lv_tolkien_table) o CROSS JOIN
             TABLE(
               SELECT CAST(COLLECT(exemplar) AS prominent_table)
               FROM   dual) n
  FETCH    FIRST 10 ROWS ONLY;

  /* Przejście w pętli po zbiorze wyników i ich wyświetlanie. */
  FOR i IN 1..lv_tolkien_plsql_table.COUNT LOOP
    dbms_output.put_line(
      '['||lv_tolkien_plsql_table(i).race||'] '||
      '['||lv_tolkien_plsql_table(i).name||'] '||
      '['||lv_tolkien_plsql_table(i).age ||']');
  END LOOP;
END;
/

DECLARE
  /* Deklaracja rekordu języka PL/SQL. */
  TYPE tolkien_record IS RECORD
  ( race      VARCHAR2(10)
  , name      VARCHAR2(20)
  , age       VARCHAR2(10));

  /* Deklaracja tabeli zagnieżdżonej z rekordami. */
  TYPE tolkien_plsql_table IS TABLE OF TOLKIEN_RECORD;

  /* Deklaracje zmiennych na rekord i tabelę zagnieżdżoną. */
  lv_tolkien_record       TOLKIEN_RECORD;
  lv_tolkien_plsql_table  TOLKIEN_PLSQL_TABLE := tolkien_plsql_table();

  /* Deklaracja tabeli zagnieżdżonej. */
  lv_tolkien_table  PEOPLE_TABLE :=
                      people_table(
                        people_object(
                           'Ludzie'
                          , prominent_object('Aragorn','3rd Age'))
                      , people_object(
                           'Elfy'
                          , prominent_object('Legolas','3rd Age')));
BEGIN
  /* Przejście po pętli i przenoszenie elementów jeden po drugim. */
  FOR i IN 1..lv_tolkien_table.COUNT LOOP
    lv_tolkien_plsql_table.EXTEND;
    lv_tolkien_plsql_table(i) := lv_tolkien_table(i);
  END LOOP;

  /* Przejście w pętli po zbiorze wyników i ich wyświetlanie. */
  FOR i IN 1..lv_tolkien_plsql_table.COUNT LOOP
    dbms_output.put_line(
      '['||lv_tolkien_plsql_table(i).race||'] '||
      '['||lv_tolkien_plsql_table(i).name||'] '||
      '['||lv_tolkien_plsql_table(i).age ||']');
  END LOOP;
END;
/

DECLARE
  /* Deklaracja rekordu języka PL/SQL. */
  TYPE tolkien_record IS RECORD
  ( race      VARCHAR2(10)
  , name      VARCHAR2(20)
  , age       VARCHAR2(10));

  /* Deklaracja tabeli zagnieżdżonej z rekordami. */
  TYPE tolkien_plsql_table IS TABLE OF TOLKIEN_RECORD;

  /* Deklaracje zmiennych na rekord i tabelę zagnieżdżoną. */
  lv_tolkien_record       TOLKIEN_RECORD;
  lv_tolkien_plsql_table  TOLKIEN_PLSQL_TABLE := tolkien_plsql_table();

  /* Deklaracja tabeli zagnieżdżonej. */
  lv_tolkien_table  PEOPLE_TABLE :=
                      people_table(
                        people_object(
                           'Ludzie'
                          , prominent_object('Aragorn','3rd Age'))
                      , people_object(
                           'Elfy'
                          , prominent_object('Legolas','3rd Age')));
BEGIN
  /* Przejście po pętli i przenoszenie elementów jeden po drugim. */
  FOR i IN 1..lv_tolkien_table.COUNT LOOP
    lv_tolkien_plsql_table.EXTEND;
    lv_tolkien_plsql_table(i).race := lv_tolkien_table(i).race;
    lv_tolkien_plsql_table(i).name := lv_tolkien_table(i).exemplar.name;
    lv_tolkien_plsql_table(i).age := lv_tolkien_table(i).exemplar.age;
  END LOOP;

  /* Przejście w pętli po zbiorze wyników i ich wyświetlanie. */
  FOR i IN 1..lv_tolkien_plsql_table.COUNT LOOP
    dbms_output.put_line(
      '['||lv_tolkien_plsql_table(i).race||'] '||
      '['||lv_tolkien_plsql_table(i).name||'] '||
      '['||lv_tolkien_plsql_table(i).age ||']');
  END LOOP;
END;
/