/* ================================================================
||   Program: create_package_variables.sql
||   Data:       2013-07-25
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   9
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   Ten skrypt ilustruje używanie zmiennych pakietu.
|| ================================================================*/

-- Po zakończeniu debugowania umieść w komentarzu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

CREATE OR REPLACE PACKAGE package_variables IS
  PRAGMA SERIALLY_REUSABLE;
  -- Deklaracja komponentów pakietu.
  PROCEDURE set(value VARCHAR2);
  FUNCTION get RETURN VARCHAR2;
END package_variables;
/

show errors

CREATE OR REPLACE PACKAGE BODY package_variables IS
  PRAGMA SERIALLY_REUSABLE;
  -- Deklaracja zmiennej z zasięgu pakietu.
  variable VARCHAR2(20) := 'Wartość początkowa';

  -- Definicja funkcji.
  FUNCTION get RETURN VARCHAR2 IS
  BEGIN
    RETURN variable;
  END get;

  -- Definicja procedury.
  PROCEDURE set(value VARCHAR2) IS
  BEGIN
    variable := value;
  END set;
END package_variables;
/

VARIABLE outcome VARCHAR2(20)

CALL package_variables.get() INTO :outcome;

SELECT :outcome AS outcome FROM dual;

EXECUTE package_variables.set('Nowa wartość');

CALL package_variables.get() INTO :outcome;

SELECT :outcome AS outcome FROM dual;
