<html>
<! ================================================================>
<!   Program: UploadItemDescription.php                            >
<!   Data:      2013-07-25                                         >
<!   Książka:   Oracle Database 12c. Programowanie w języku PL/SQL >
<!   Rozdział:  10                                                 >
<!   Autor:  Michael McLaughlin                                    >
<! ---------------------------------------------------------------->
<!   Zawartość:                                                    >
<!   ---------                                                     >
<!   Ten skrypt ilustruje przesyłanie pliku, przenoszenie          >
<!   przesłanego pliku, zapisywanie danych w kolumnie typu CLOB    >
<!   za pomocą procedury składowanej języka PL/SQL, dostęp do      >
<!   danych zapisanych w bazie i wyświetlanie strony.              >
<! ---------------------------------------------------------------->
<!   UWAGI:                                                        >
<!                                                                 >
<!   Ten program wymaga, aby procedura web_lob_clob_from_file      >
<!   była dostępna w schemacie PLSQL. Aby ją utworzyć, wywołaj:    >
<!                                                                 >
<!   create_web_clob_loading.sql                                   >
<head>
<title>
  Rozdział 10. UploadItemDescription.php
</title>
<style>
.e {background-color: #ccccff; font-weight: bold; color: #000000;}
.v {background-color: #cccccc; color: #000000;}
</style>
</head>
<body>
<?php
  // Wyświetlanie przeniesionego pliku na stronie.
  $item_desc = process_uploaded_file();

  // Próba nawiązania połączenia z bazą danych.
  if ($c = @oci_connect("plsql","plsql","orcl"))
  {
    // Deklaracja zmiennych wejściowych.
    (isset($_POST['id']))    ? $id = (int) $_POST['id'] : $id = 1021;
    (isset($_POST['title'])) ? $title = $_POST['title'] : $title = "Harry #1";

    // Deklaracja polecenia języka PL/SQL.
    $stmt = "BEGIN
               web_load_clob_from_file(:id,:item_desc);
             END;";

    // Usuwanie znaków specjalnych w celu uniknięcia błędów ORA-06550 i PLS-00103.
    $stmt = strip_special_characters($stmt);

    // Parsowanie zapytania z wykorzystaniem połączenia.
    $s = oci_parse($c,$stmt);

    // Definiowanie deskryptora obiektu CLOB.
    $rlob = oci_new_descriptor($c,OCI_D_LOB);

    // Definiowanie zmiennej wiązanej z deskryptorem obiektu CLOB.
    oci_define_by_name($s,':item_desc',$rlob,SQLT_CLOB);

    // Wiązanie zmiennych języka PHP z typami OCI.
    oci_bind_by_name($s,':id',$id);
    oci_bind_by_name($s,':item_desc',$rlob,-1,SQLT_CLOB);

    // Wykonywanie instrukcji języka PL/SQL.
    if (oci_execute($s,OCI_DEFAULT))
    {

      $rlob->save($item_desc);
      oci_commit($c);
      query_insert($id,$title);
    }

    // Zamykanie połączenia z bazą.
    oci_close($c);
  }
  else
  {
    // Przypisywanie błędu OCI i formatowanie apostrofów oraz cudzysłowów.
    $errorMessage = oci_error();
    print htmlentities($errorMessage['message'])."<br />";
  }

  // Pobieranie wyników po wstawieniu danych.
  function query_insert($id,$title)
  {
    // Próba nawiązania połączenia z bazą.
    if ($c = @oci_new_connect("plsql","plsql","orcl"))
    {
      // Deklaracja SQL-owej instrukcji SELECT zwracającej obiekt typu CLOB.
      $stmt = "SELECT   item_desc
               FROM     item
               WHERE    item_id = :id";

      // Parsowanie zapytania z wykorzystaniem połączenia.
      $s = oci_parse($c,$stmt);

      // Wiązanie zmiennych języka PHP z typami OCI.
      oci_bind_by_name($s,':id',$id);

      // Wykonywanie instrukcji języka PL/SQL.
      if (oci_execute($s))
      {
        // Zwracanie deskryptora obiektu LOB.
        while (oci_fetch($s))
        {
          for ($i = 1;$i <= oci_num_fields($s);$i++)
            if (is_object(oci_result($s,$i)))
            {
              if ($size = oci_result($s,$i)->size())
                $data = oci_result($s,$i)->read($size);
              else
                $data = "&nbsp;";
            }
            else
            {
              if (oci_field_is_null($s,$i))
                $data = "&nbsp;";
              else
                $data = oci_result($s,$i);
            }
        } // Koniec pętli while(oci_fetch($s)).

        // Formatowanie tabeli HTML-a w celu wyświetlenia tekstu.
        $out = '<table border="1" cellpadding="3" cellspacing="0">';
        $out .= '<tr>';
        $out .= '<td align="center" class="e">'.$title.'</td>';
        $out .= '</tr>';
        $out .= '<tr>';
        $out .= '<td class="v">'.$data.'</td>';
        $out .= '</tr>';
        $out .= '</table>';

      }

      // Wyświetlanie tabeli HTML-a.
      print $out;

      // Zamknięcie połączenia z bazą danych.
      oci_close($c);
    }
    else
    {
      // Przypisanie błędu OCI oraz formatowanie apostrofów i cudzysłowów.
      $errorMessage = oci_error();
      print htmlentities($errorMessage['message'])."<br />";
    }
  }

  // Zarządza przesyłaniem pliku i zwraca plik jako łańcuch znaków.
  function process_uploaded_file()
  {
    // Deklaracja zmiennej na zawartość pliku.
    $contents = "";

    // Definiowanie nazwy przesyłanego pliku na potrzeby systemów Windows i Linux.
    if (ereg("Win32",$_SERVER["SERVER_SOFTWARE"]))
      $upload_file = getcwd()."\\temp\\".$_FILES['userfile']['name'];
    else
      $upload_file = getcwd()."/temp/".$_FILES['userfile']['name'];

    // Sprawdzanie dostępności przesłanego pliku i przenoszenie go.
    if (is_uploaded_file($_FILES['userfile']['tmp_name']))
      move_uploaded_file($_FILES['userfile']['tmp_name'],$upload_file);

    // Otwieranie uchwytu do pliku i blokowanie błędów braku pliku.
    if ($fp = @fopen($upload_file,"r"))
    {
      // Wczytywanie danych do momentu dotarcia do znacznika końca pliku.
      while (!feof($fp))
        $contents .= fgetc($fp);

      // Zamykanie otwartego uchwytu do pliku.
      fclose($fp);
    }

	// Zwracanie zawartości pliku jako łańcucha znaków.
    return $contents;
  }

  // Usuwanie znaków specjalnych (na przykład znaków przejścia do nowego wiersza i tabulacji).
  function backquote_apostrophe($str)
  {
    $out = "";
    for ($i = 0;$i < strlen($str);$i++)
      if (ord($str[$i]) != 39)
        $out .= $str[$i];
      else
        $out .= "'".$str[$i];
    // Zwracanie instrukcji SQL-a po wstępnym parsowaniu.
    return $out;
  }

  // Usuwanie znaków specjalnych (na przykład znaków przejścia do nowego wiersza i tabulacji).
  function strip_special_characters($str)
  {
    $out = "";
    for ($i = 0;$i < strlen($str);$i++)
      if ((ord($str[$i]) != 9) && (ord($str[$i]) != 10) &&
          (ord($str[$i]) != 13))
        $out .= $str[$i];

    // Zwracanie instrukcji SQL-a po wstępnym parsowaniu.
    return $out;
  }
?>
</body>
</html>