/* ================================================================
||   Program Name: recursive.sql
||   Data:       2013-07-25
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   8
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   Ten skrypt ilustruje funkcje rekurencyjne.
|| ================================================================*/

-- Po zakończeniu debugowania umieść w komentarzu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 99999
SET SERVEROUTPUT ON SIZE UNLIMITED

-- Tworzenie programu z rekurencją liniową.
CREATE OR REPLACE FUNCTION factorial
( n BINARY_DOUBLE ) RETURN BINARY_DOUBLE IS
BEGIN
  IF n <= 1 THEN
    RETURN 1;
  ELSE
    RETURN n * factorial(n - 1);
  END IF;
END factorial;
/

/* Obliczanie ciągu Fibonacciego za pomocą rekurencji nieliniowej. */
CREATE OR REPLACE FUNCTION "Fibonacci"
( n BINARY_DOUBLE ) RETURN BINARY_DOUBLE IS
BEGIN
  /* Przypadek bazowy. */
  IF n < 2 THEN
    RETURN n;
  ELSE
    RETURN fibonacci(n - 2) + fibonacci(n - 1);
  END IF;
END "Fibonacci";
/

CREATE OR REPLACE FUNCTION "FibonacciSequence"
RETURN VARCHAR2 IS
  /* Deklaracja zmiennej wyjściowej. */
  lv_output  VARCHAR2(40);
BEGIN
  /* Przejście w pętli (liczba powtórzeń wystarczająca do rozwiązania
     zagadki z książki Kod Leonarda da Vinci. */
  FOR i IN 1..8 LOOP
    IF lv_output IS NOT NULL THEN
      lv_output := lv_output||', '||LTRIM(TO_CHAR("Fibonacci"(i),'999'));
    ELSE
      lv_output := LTRIM(TO_CHAR("Fibonacci"(i),'999'));
    END IF;
  END LOOP;
  RETURN lv_output;
END;
/

SELECT   "FibonacciSequence"
FROM     dual;