/* ================================================================
||   Program: create_dbms_sql5.sql
||   Data:       2013-07-25
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   13
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   Ten skrypt ilustruje używanie pakietu DBMS_SQL do pobierania wiersza. 
|| ================================================================*/

-- Po debugowaniu umieść w komentarzu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  c                         INTEGER := dbms_sql.open_cursor;
  fdbk                      INTEGER;
  statement                 VARCHAR2(2000);
  item1                     NUMBER := 1003;
  item2                     NUMBER := 1013;
  item_title                VARCHAR2(60);
  item_subtitle             VARCHAR2(60);

BEGIN

  -- Tworzenie i parsowanie instrukcji SQL-a.
  statement := 'SELECT item_title, item_subtitle '
            || 'FROM item '
            || 'WHERE item_id BETWEEN :item1 AND :item2 '
            || 'AND item_type = 1014';
  dbms_sql.parse(c,statement,dbms_sql.native);

  -- Definiowanie zmiennych i wykonywanie instrukcji .
  dbms_sql.define_column(c,1,item_title,60);    -- Definiowanie zmiennej w trybie OUT.
  dbms_sql.define_column(c,2,item_subtitle,60); -- Definiowanie zmiennej w trybie OUT.
  dbms_sql.bind_variable(c,'item1',item1);      -- Wiązanie zmiennej w trybie IN.
  dbms_sql.bind_variable(c,'item2',item2);      -- Wiązanie zmiennej w trybie IN.
  fdbk := dbms_sql.execute(c);
  
  -- Wczytywanie wyników.
  LOOP
    EXIT WHEN dbms_sql.fetch_rows(c) = 0;       -- Wczytano wszystkie wyniki.
    
    -- Kopiowanie i wyświetlanie.
    dbms_sql.column_value(c,1,item_title);        -- Kopiowanie wartości kolumny do zmiennej.
    dbms_sql.column_value(c,2,item_subtitle);     -- Kopiowanie wartości kolumny do zmiennej.
    dbms_output.put_line('['||item_title||']['||NVL(item_subtitle,'Brak')||']');
    
  END LOOP;
  dbms_sql.close_cursor(c);

END;
/