<?php
  /* ================================================================
  ||   Program Name: ConvertFileToImage.php
  ||   Data:       2013-07-25
  ||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
  ||   Rozdział:   10
  ||   Autor:  Michael McLaughlin
  || ----------------------------------------------------------------
  ||   Zawartość:
  ||   ---------
  ||   Ten nagłówek musi znajdować się w znaczniku skryptu PHP, ponieważ
  ||   nic nie może zostać wygenerowane przed wywołaniem funkcji header()
  ||   informującej, że zwracany jest plik PNG.
  || ================================================================*/

  // Próba nawiązania połączenia z bazą danych.
  if ($c = @oci_new_connect("plsql","plsql","orcl"))
  {
    // Deklaracja zmiennych wejściowych.
    (isset($_GET['id']))    ? $id = (int) $_GET['id'] : $id = 1021;

    // Deklaracja SQL-owej instrukcji SELECT zwracającej wartość typu CLOB.
    $stmt = "SELECT   item_photo
             FROM     item
             WHERE    item_id = :id";

    // Parsowanie zapytania z wykorzystaniem nawiązanego połączenia.
    $s = oci_parse($c,$stmt);

    // Wiązanie zmiennych PHP z typami OCI.
    oci_bind_by_name($s,':id',$id);

    // Wykonywanie instrukcji języka PL/SQL.
    if (oci_execute($s))
    {
      // Zwracanie deskryptora obiektu LOB i zwalnianie zasobów.
      while (oci_fetch($s))
      {
        for ($i = 1;$i <= oci_num_fields($s);$i++)
          if (is_object(oci_result($s,$i)))
          {
            if ($size = oci_result($s,$i)->size())
            {
              $data = oci_result($s,$i)->read($size);
            }
            else
              $data = "&nbsp;";
          }
          else
          {
            if (oci_field_is_null($s,$i))
              $data = "&nbsp;";
            else
              $data = oci_result($s,$i);
          }
      } // Koniec pętli while(oci_fetch($s)).

      // Zwalnianie zasobów.
      oci_free_statement($s);

      // Najpierw zwracany jest nagłówek.
      header('Content-type: image/png');
      imagepng(imagecreatefromstring($data));
    }

    // Zamknięcie połączenia z bazą.
    oci_close($c);
  }
  else
  {
    // Przypisanie błędu OCI i formatowanie apostrofów oraz cudzysłowów.
    $errorMessage = oci_error();
    print htmlentities($errorMessage['message'])."<br />";
  }
?>