/* ================================================================
||   Program: pass_by_reference.sql
||   Data:       2013-07-25
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   8
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   Ten skrypt ilustruje funkcje o parametrach przekazywanych
||   przez referencję.
|| ================================================================*/

SET SERVEROUTPUT ON SIZE UNLIMITED

-- Po zakończeniu debugowania umieść w komentarzu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 99999
SET SERVEROUTPUT ON SIZE UNLIMITED

CREATE OR REPLACE FUNCTION counting
( number_in IN OUT NUMBER ) RETURN VARCHAR2 IS
  TYPE numbers IS TABLE OF VARCHAR2(5);
  ordinal NUMBERS := numbers('One','Two','Three','Four','Five');
  retval VARCHAR2(9) := 'Nie znaleziono';
BEGIN
  -- Zastępowanie wartości null, aby umożliwić poprawną inkrementację.
  IF number_in IS NULL THEN
    number_in := 1;
  END IF; 
  -- Zwiększanie wartości parametru, jeśli wartość nie wyszła poza zasięg.
  IF number_in < 4 THEN
    retval := ordinal(number_in);
    number_in := number_in + 1;
  ELSE
    retval := ordinal(number_in);
  END IF;
  RETURN retval;
END;
/

DECLARE
  counter NUMBER := 1;
BEGIN
  FOR i IN 1..5 LOOP
    dbms_output.put('Licznik ['||counter||']');
    dbms_output.put_line('['||counting(counter)||']');
  END LOOP;
END;
/
