/* ================================================================
||   Program: hobbit.sql
||   Data:       2013-12-02
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   3
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   Ten skrypt tworzy obiekty używane w kompletnym przykładzie
||   ilustrującym specyfikację i ciało typu obiektowego HOBBIT,
||   a także bloki anonimowe testujące działanie tego typu.
|| ================================================================*/


-- Warunkowe usuwanie typu obiektowego HOBBIT.
BEGIN
  FOR i IN (SELECT object_name
            FROM   user_objects
            WHERE  object_name = 'HOBBIT'
            AND    object_type = 'TYPE') LOOP
    /* Dynamiczne usuwanie typu obiektowego HOBBIT. */
    EXECUTE IMMEDIATE 'DROP TYPE '||i.object_name||' FORCE';
  END LOOP;
END;
/

-- Tworzenie lub zastępowanie typu hobbit.
CREATE OR REPLACE TYPE hobbit IS OBJECT
( name VARCHAR2(20)
, CONSTRUCTOR FUNCTION hobbit RETURN SELF AS RESULT
, CONSTRUCTOR FUNCTION hobbit
( name VARCHAR2 ) RETURN SELF AS RESULT
, MEMBER FUNCTION get_name RETURN VARCHAR2
, MEMBER FUNCTION set_name (name VARCHAR2)
  RETURN hobbit
, MEMBER FUNCTION to_string RETURN VARCHAR2 )
  INSTANTIABLE NOT FINAL;
/

-- Tworzenie lub zastępowania ciała typu obiektowego hobbit.
CREATE OR REPLACE TYPE BODY hobbit IS
  /* Konstruktor domyślny (bez parametrów). */
  CONSTRUCTOR FUNCTION hobbit RETURN SELF AS RESULT IS
    lv_hobbit HOBBIT := hobbit('Sam Gamgee');
  BEGIN
    self := lv_hobbit;
    RETURN;
  END hobbit;
  /* Sygnatura przesłaniająca. */
  CONSTRUCTOR FUNCTION hobbit
  (name VARCHAR2) RETURN self AS RESULT IS
  BEGIN
    self.name := name;
    RETURN;
  END hobbit;
  /* Getter dla jedynego atrybutu tego typu obiektowego. */
  MEMBER FUNCTION get_name RETURN VARCHAR2 IS
  BEGIN
    RETURN self.name;
  END get_name;
  /* Setter zwracający nową kopię obiektu tego typu. */
  MEMBER FUNCTION set_name (name VARCHAR2)
  RETURN hobbit IS
    lv_hobbit HOBBIT;
  BEGIN
    lv_hobbit := hobbit(name);
    RETURN lv_hobbit;
  END set_name;
  /* Prints a salutation of the object type's attribute. */
  /* Wyświetlanie pozdrowienia z imieniem z atrybutu z tego typu obiektowego. */
  MEMBER FUNCTION to_string RETURN VARCHAR2 IS
  BEGIN
    RETURN 'Witaj, '||self.name||'!';
  END to_string;
END;
/

-- Zapytanie z użyciem samego typu obiektowego (wywołanie statyczne).
COLUMN salutation FORMAT A20
SELECT hobbit().to_string() AS "Pozdrowienie"
FROM dual;

-- Zapytanie z użyciem egzemplarza typu obiektowego.
SELECT hobbit('Bilbo Baggins').to_string() AS "Pozdrowienie"
FROM dual;

-- Zapytanie z użyciem egzemplarza typu obiektowego.
SELECT hobbit().set_name('Frodo Baggins').to_string() AS "Pozdrowienie"
FROM dual;

-- ------------------------------------------------------------
--   Typ rekordowy z języka PL/SQL
-- ------------------------------------------------------------

CREATE OR REPLACE 
  TYPE string_table IS TABLE OF VARCHAR2(20);
/

CREATE OR REPLACE
  TYPE hobbit_table IS TABLE OF HOBBIT;
/

SELECT 'Witaj' FROM dual;

SET SERVEROUTPUT ON SIZE UNLIMITED
DECLARE
  -- Deklarowanie i inicjowanie kolekcji hobbitów.
  lv_string_table string_TABLE :=
     string_table('Drogo Baggins','Frodo Baggins');
  lv_hobbit_table HOBBIT_TABLE := hobbit_table(
     hobbit('Bungo Baggins')
   , hobbit('Bilbo Baggins'));
BEGIN
  -- Przenoszenie elementów z jednej kolekcji do innej.
  FOR i IN 1..lv_string_table.COUNT LOOP
    lv_hobbit_table.EXTEND;
    lv_hobbit_table(lv_hobbit_table.COUNT) :=
      hobbit(lv_string_table(i));
  END LOOP;

  -- Wyświetlanie elementów z tabeli hobbit.
  FOR i IN 1..lv_hobbit_table.COUNT LOOP
    dbms_output.put_line(
      lv_hobbit_table(i).to_string());
  END LOOP;
END;
/

CREATE OR REPLACE FUNCTION get_hobbits
RETURN HOBBIT_TABLE IS
  -- Deklaracja kolekcji hobbitów.
  lv_hobbit_table HOBBIT_TABLE := hobbit_table(
     hobbit('Bungo Baggins')
   , hobbit('Bilbo Baggins')
   , hobbit('Drogo Baggins')
   , hobbit('Frodo Baggins'));
BEGIN
  RETURN lv_hobbit_table;
END;
/

COLUMN hobbit_name FORMAT A14
SELECT name AS hobbit_name
FROM TABLE(get_hobbits())
ORDER BY 1;