/* ================================================================
||   Program: create_dbms_sql4.sql
||   Data:       2013-07-25
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   13
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   Ten skrypt ilustruje używanie pakietu DBMS_SQL do pobierania wiersza. 
|| ================================================================*/

-- Po debugowaniu umieść w komentarzu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  c                         INTEGER := dbms_sql.open_cursor;
  fdbk                      INTEGER;
  statement                 VARCHAR2(2000);
  item_id                   NUMBER := 1081;
  item_title                VARCHAR2(60);
  item_subtitle             VARCHAR2(60);

BEGIN

  -- Tworzenie i parsowanie instrukcji SQL-a.
  statement := 'SELECT item_title, item_subtitle '
            || 'FROM item WHERE item_id = :item_id';
  dbms_sql.parse(c,statement,dbms_sql.native);

  -- Definiowanie zmiennych, wykonywanie instrukcji i kopiowanie wyników.
  dbms_sql.define_column(c,1,item_title,60);    -- Definiowanie zmiennej w trybie OUT.
  dbms_sql.define_column(c,2,item_subtitle,60); -- Definiowanie zmiennej w trybie OUT.
  dbms_sql.bind_variable(c,'item_id',item_id);  -- Wiązanie zmiennej w trybie IN.
  fdbk := dbms_sql.execute_and_fetch(c);
  dbms_sql.column_value(c,1,item_title);        -- Kopiowanie wartości kolumny do zmiennej.
  dbms_sql.column_value(c,2,item_subtitle);     -- Kopiowanie wartości kolumny do zmiennej.

  -- Wyświetlanie zwracanej wartości i zamykanie kursora.
  dbms_output.put_line('['||item_title||']['||NVL(item_subtitle,'Brak')||']');
  dbms_sql.close_cursor(c);

END;
/