/* ================================================================
||   Program: create_dbms_sql1.sql
||   Data:       2013-07-25
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   13
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   Ten skrypt ilustruje używanie pakietu DBMS_SQL do warunkowego usuwania tabeli.
|| ================================================================*/

-- Po debugowaniu umieść w komentarzu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  -- Definicje zmiennych lokalnych na potrzeby pakietu DBMS_SQL.
  c         INTEGER := dbms_sql.open_cursor;
  fdbk      INTEGER;
  stmt      VARCHAR2(2000);

BEGIN
  -- Używanie pętli do sprawdzenia, czy należy usunąć sekwencję.
  FOR i IN (SELECT null
            FROM   user_objects
            WHERE  object_name = 'SAMPLE_SEQUENCE') LOOP

    -- Tworzenie dynamicznej instrukcji SQL-a.
    stmt := 'DROP SEQUENCE sample_sequence';

    -- Parsowanie i wykonywanie instrukcji.
    dbms_sql.parse(c,stmt,dbms_sql.native);
    fdbk := dbms_sql.execute(c);

    -- Zamykanie otwartego kursora.
    dbms_sql.close_cursor(c);

    -- Wyświetlanie wiersza z danymi wyjściowymi.
    dbms_output.put_line('Usunięto sekwencję [SAMPLE_SEQUENCE]');
  END LOOP;
END;
/