/* ================================================================
||   Program: create_web_clob_loading.sql
||   Data:       2013-07-25
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   10
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   Ten skrypt ilustruje procedurę wczytującą wartość typu CLOB.
|| ================================================================*/

CREATE OR REPLACE PROCEDURE web_load_clob_from_file  
( item_id_in IN     NUMBER
, descriptor IN OUT CLOB ) IS

BEGIN

  UPDATE    item
  SET       item_desc = empty_clob()
  WHERE     item_id = item_id_in
  RETURNING item_desc INTO descriptor;
       
END web_load_clob_from_file;
/

