/* ================================================================
||   Program: pipelined.sql
||   Data:       2013-07-25
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   8
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   Ten skrypt ilustruje funkcje potokowe.
|| ================================================================*/

SET SERVEROUTPUT ON SIZE UNLIMITED

-- Po zakończeniu debugowania umieść w komentarzu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

CREATE OR REPLACE FUNCTION pipelined_numbers
RETURN NUMBERS
PIPELINED IS
  list NUMBERS := numbers(0,1,2,3,4,5,6,7,8,9);
BEGIN
  FOR i IN 1..list.LAST LOOP
    PIPE ROW(list(i));
  END LOOP;
  RETURN;
END;
/

CREATE OR REPLACE PACKAGE pipelined IS
  /* Deklaracja typu rekordowego języka PL/SQL i typu kolekcji. */
  TYPE account_record IS RECORD
  ( account     VARCHAR2(10)
  , full_name   VARCHAR2(42));
  TYPE account_table IS TABLE OF account_record;
  
  /* Deklaracja funkcji potokowej. */
  FUNCTION pf RETURN account_table PIPELINED;
END pipelined;
/

CREATE OR REPLACE PACKAGE BODY pipelined IS
  -- Implementacja funkcji potokowej.
  FUNCTION pf
  RETURN account_table
  PIPELINED IS
    /* Deklaracje zmiennych na licznik i kolekcję. */
    counter NUMBER := 1;
    account ACCOUNT_TABLE := account_table();
    
    /* Definicja kursora. */
    CURSOR c IS
      SELECT   m.account_number
      ,        c.last_name || ', '||c.first_name full_name
      FROM     member m JOIN contact c ON m.member_id = c.member_id
      ORDER BY c.last_name, c.first_name, c.middle_initial;
  BEGIN
    FOR i IN c LOOP
      /* Przydzielanie pamięci i dodawanie wartości do kolekcji. */
      account.EXTEND;
      account(counter).account   := i.account_number;
      account(counter).full_name := i.full_name;
      
	  /* Przypisywanie elementu kolekcji do potokou. */
      PIPE ROW(account(counter));
      counter := counter + 1;
    END LOOP;
    RETURN;
  END pf;
END pipelined;
/

SELECT * FROM TABLE(pipelined.pf);

CREATE OR REPLACE PACKAGE BODY pipelined IS
  -- Implementacja funkcji potokowej.
  FUNCTION pf
  RETURN account_table
  PIPELINED IS
    /* Deklaracje zmiennych na licznik i kolekcję. */
    counter NUMBER := 1;
    account ACCOUNT_TABLE := account_table();
    
    /* Definicja kursora. */
    CURSOR c IS
      SELECT   m.account_number
      ,        c.last_name || ', '||c.first_name full_name
      FROM     member m JOIN contact c ON m.member_id = c.member_id
      ORDER BY c.last_name, c.first_name;
  BEGIN
    FOR i IN c LOOP
      /* Przydzielanie pamięci i dodawanie wartości do kolekcji. */
      account.EXTEND;
      account(counter) := i;
      
      /* Przypisywanie elementu kolekcji do potokou. */
      PIPE ROW(account(counter));
      counter := counter + 1;
    END LOOP;
    RETURN;
  END pf;
END pipelined;
/

SELECT * FROM TABLE(pipelined.pf);


CREATE OR REPLACE FUNCTION pf
RETURN pipelined.account_collection
PIPELINED IS
    -- Deklaracje zmiennych na licznik i kolekcję.
    counter NUMBER := 1;
    account PIPELINED.ACCOUNT_COLLECTION := pipelined.account_collection();
    
    -- Definicja kursora.
    CURSOR c IS
      SELECT   m.account_number
      ,        c.last_name || ', '||c.first_name full_name
      FROM     member m JOIN contact c ON m.member_id = c.member_id
      ORDER BY c.last_name, c.first_name, c.middle_initial;
  BEGIN
    FOR i IN c LOOP
      account.EXTEND;
      account(counter).account   := i.account_number;
      account(counter).full_name := i.full_name;
      PIPE ROW(account(counter));
      counter := counter + 1;
    END LOOP;
    RETURN;
  END pf;
/

SELECT * FROM TABLE(pf);

CREATE OR REPLACE PROCEDURE read_pipe
( pipe_in pipelined.account_collection ) IS
BEGIN
  FOR i IN 1..pipe_in.LAST LOOP
    dbms_output.put(pipe_in(i).account);
    dbms_output.put(pipe_in(i).full_name);
  END LOOP;
END read_pipe;
/

EXECUTE read_pipe(pf);
