/* ================================================================
||   Program:    white_list.sql
||   Data:       2013-12-02
||   Ksika:    Oracle Database 12c. Programowanie w jzyku PL/SQL
||   Rozdzia:   2
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawarto:
||   ---------
||   Ten skrypt tworzy obiekty uywane w kompletnym przykadzie ilustrujcym
||   stosowanie biaych list dla funkcji, procedur, typw i pakietw.
|| ================================================================*/

-- Warunkowe usuwanie typu obiektowego HOBBIT.
BEGIN
  FOR i IN (SELECT object_name
            FROM   user_objects
            WHERE  object_name = 'HOBBIT'
            AND    object_type = 'TYPE') LOOP
    /* Dynamiczne usuwanie typu obiektowego. */
    EXECUTE IMMEDIATE 'DROP TYPE '||i.object_name||' FORCE';
  END LOOP;
END;
/

-- Tworzenie typu obiektowego HOBBIT.
CREATE OR REPLACE TYPE hobbit IS OBJECT
( name  VARCHAR2(20)
, CONSTRUCTOR FUNCTION hobbit  RETURN SELF AS RESULT
, CONSTRUCTOR FUNCTION hobbit
  ( name  VARCHAR2 ) RETURN SELF AS RESULT
, MEMBER FUNCTION get_name RETURN VARCHAR2
, MEMBER FUNCTION set_name (name VARCHAR2)
  RETURN hobbit
, MEMBER FUNCTION to_string RETURN VARCHAR2 )
  INSTANTIABLE NOT FINAL;
/ 

-- Tworzenie ciaa typu obiektowego HOBBIT.
CREATE OR REPLACE TYPE BODY hobbit IS

  /* Konstruktor domylny (bez parametrw). */
  CONSTRUCTOR FUNCTION hobbit RETURN SELF AS RESULT IS
    lv_hobbit HOBBIT := hobbit('Sam Gamgee');
  BEGIN
    self := lv_hobbit;
    RETURN;
  END hobbit;

  /* Sygnatura przesaniajca. */
  CONSTRUCTOR FUNCTION hobbit
  (name  VARCHAR2) RETURN self AS RESULT IS
  BEGIN
    self.name := name;
    RETURN;
  END hobbit;

  /* Getter jedynego atrybutu tego typu obiektowego. */
  MEMBER FUNCTION get_name RETURN VARCHAR2 IS
  BEGIN
    RETURN self.name;
  END get_name;

  /* Setter zwracajcy now kopi tego typu obiektowego. */
  MEMBER FUNCTION set_name (name VARCHAR2)
  RETURN hobbit IS
    lv_hobbit HOBBIT;
  BEGIN
    lv_hobbit := hobbit(name);
    RETURN lv_hobbit;
  END set_name;

  /* Wywietla pozdrowienie z imieniem zapisanym w atrybucie tego typu obiektowego. */
  MEMBER FUNCTION to_string RETURN VARCHAR2 IS
  BEGIN
    RETURN 'Witaj, '||self.name||'!';
  END to_string;
END;
/

-- Tworzenie specyfikacji pakietu api.
CREATE OR REPLACE PACKAGE api IS
  FUNCTION whom
  ( pv_message  VARCHAR2 ) RETURN VARCHAR2;
END;
/

-- Tworzenie ciaa pakietu.
CREATE OR REPLACE PACKAGE BODY api IS
  FUNCTION whom
  ( pv_message  VARCHAR2 ) RETURN VARCHAR2 IS
  BEGIN
    RETURN library(pv_message);
  END;
END;
/

-- Tworzenie funkcji GATEWAY.
CREATE OR REPLACE FUNCTION gateway
( pv_message  VARCHAR2 ) RETURN VARCHAR2 IS
BEGIN
  /* Zwraca wynik z funkcji library. */
  RETURN library(pv_message);
END;
/


-- Tworzenie funkcji LIBRARY.
CREATE OR REPLACE FUNCTION library
( pv_message  VARCHAR2 ) RETURN VARCHAR2 IS
BEGIN
  RETURN pv_message;
END;
/

-- Tworzenie funkcji library z bia list LIBRARY.
CREATE OR REPLACE FUNCTION library
( pv_message  VARCHAR2 ) RETURN VARCHAR2
ACCESSIBLE BY
( FUNCTION  video.gateway
, PROCEDURE video.backdoor
, PACKAGE   video.api
, TYPE      video.hobbit ) IS
  lv_message  VARCHAR2(30) := 'Witaj, ';
BEGIN
  lv_message := lv_message || pv_message || '!';
  RETURN lv_message;
END;
/

SET SERVEROUTPUT ON SIZE UNLIMITED

-- Tworzenie funkcji BACKDOOR, ktra nie zadziaa, poniewa na biaej licie BACKDOOR to procedura.
CREATE OR REPLACE FUNCTION backdoor
( pv_message  VARCHAR2 ) RETURN VARCHAR2 IS
BEGIN
  /* Zwracanie wyniku funkcji library. */
  RETURN library(pv_message);
END;
/

-- Wywietlanie bdw.
SHOW ERRORS

-- Tworzenie funkcji BLACK_NIGHT function, ktra nie zadziaa, poniewa jej nazwy nie ma na biaej licie. 
CREATE OR REPLACE FUNCTION black_night
( pv_message  VARCHAR2 ) RETURN VARCHAR2 IS
BEGIN
  RETURN library(pv_message);
END;
/

-- Wywietlanie bdw.
SHOW ERRORS

-- Tworzenie funkcji GATEWAY, ktra zadziaa, poniewa znajduje si na biaej licie. 
CREATE OR REPLACE FUNCTION gateway
( pv_message  VARCHAR2 ) RETURN VARCHAR2 IS
BEGIN
  RETURN library(pv_message);
END;
/

-- Zwracanie wartoci z wywoania funkcji podanej na biaej licie.
SELECT gateway('GATEWAY function') AS "SELECT-List Value" FROM dual; 

-- Deklaracja zmiennej sesji.
VARIABLE receiver VARCHAR2(80)

-- Uruchamianie funkcji z biaej listy .
CALL gateway('GATEWAY function') INTO :receiver;

-- Zwracanie wartoci zapisanej w zmiennej sesji.
SELECT :receiver AS "Zmienna sesji" FROM dual;    