/* ================================================================
||   Program:    dynamic_range.sql
||   Data:       2013-12-02
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   2
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   Ten skrypt tworzy obiekty używane w kompletnym przykładzie ilustrującym
||   dynamiczne ustawianie przedziałów.
|| ================================================================*/

-- Warunkowe usuwanie typu obiektowego ITEM_TITLE_TABLE.
BEGIN
  FOR i IN (SELECT object_name
            FROM   user_objects
            WHERE  object_name = 'ITEM_TITLE_TABLE'
            AND    object_type = 'TYPE') LOOP
    /* Dynamiczne usuwanie typu obiektowego. */
    EXECUTE IMMEDIATE 'DROP TYPE '||i.object_name||' FORCE';
  END LOOP;
END;
/

-- Tworzenie lub zastępowanie kolekcji typu ADT. 
CREATE OR REPLACE
  TYPE item_title_table AS TABLE OF VARCHAR2(60);
/

-- Właczanie zmiennej SERVEROUTPUT na potrzeby skryptu.
SET SERVEROUTPUT ON SIZE UNLIMITED

-- Tworzenie lub zastępowanie funkcji DYNAMIC_RANGE.
CREATE OR REPLACE FUNCTION dynamic_range
( pv_offset  NUMBER
, pv_rows    NUMBER ) RETURN item_title_table IS

  /* Deklaracja typu kolekcji. */
  lv_item_title_table  ITEM_TITLE_TABLE := item_title_table();

  /* Zmienna lokalna. */
  lv_item_title   VARCHAR2(60);

  /* Deklaracja lokalnego licznika. */
  lv_counter  NUMBER := 1;

  /* Zmienne na lokalną instrukcję NDS i kursor. */
  lv_stmt    VARCHAR2(2000);
  lv_cursor  SYS_REFCURSOR;

BEGIN

  /* Przypisywanie dynamicznej instrukcji SQL-a do zmiennej lokalnej. */
  lv_stmt := 'SELECT   i.item_title'||CHR(10)
          || 'FROM     item i'||CHR(10)
          || 'OFFSET :bv_offset ROWS FETCH FIRST :bv_rows ROWS ONLY';
 
  /* Otwieranie kursora dla dynamicznej instrukcji. */
  OPEN lv_cursor FOR lv_stmt USING pv_offset, pv_rows;
  LOOP
    /* Pobieranie wartości z kursora i przypisywanie jej do zmiennej lokalnej. */
    FETCH lv_cursor INTO lv_item_title;

    /* Wyjście, jeśli nie ma więcej rekordów. */
    EXIT WHEN lv_cursor%NOTFOUND;

    /* Przydzielanie dodatkowej pamięci, przypisywanie wartości i zwiększanie licznika. */
    lv_item_title_table.EXTEND;
    lv_item_title_table(lv_counter) := lv_item_title;
    lv_counter := lv_counter + 1;
  END LOOP;

  /* Zamykanie kursora. */
  CLOSE lv_cursor;

  /* Zwracanie kolekcji. */
  RETURN lv_item_title_table;
END;
/

-- Zapytanie pobierające wartości zwrócone przez dynamicznie ograniczony kursor.
SELECT   COLUMN_VALUE AS item_title
FROM     TABLE(dynamic_range(2,5));